/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.config;

import com.electronwill.nightconfig.core.utils.ConfigWrapper;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAir;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import tamaized.aov.AoV;

@Mod.EventBusSubscriber(modid="aov")
public class ConfigHandler {
    public static Set<Item> CENTERED_WEAR = ImmutableSet.of();
    public ConfigWrapper file;
    public ElementPositions ELEMENT_POSITIONS = new ElementPositions();
    public Earthquake EARTHQUAKE = new Earthquake();
    public ForgeConfigSpec.IntValue maxlevel;
    public ForgeConfigSpec.ConfigValue<Integer> recharge;
    public ForgeConfigSpec.BooleanValue experience;
    public ForgeConfigSpec.BooleanValue handwrapsSpeed;
    public ForgeConfigSpec.BooleanValue renderBarOverHotbar;
    public ForgeConfigSpec.BooleanValue renderChargesAboveSpellbar;
    public ForgeConfigSpec.BooleanValue renderAstro;
    public ForgeConfigSpec.BooleanValue renderRoyalRoad;
    public ForgeConfigSpec.BooleanValue renderTarget;
    public ForgeConfigSpec.IntValue stencil;
    public ForgeConfigSpec.DoubleValue targetOpacity;
    public ForgeConfigSpec.ConfigValue<List<? extends String>> centered;

    public ConfigHandler(ForgeConfigSpec.Builder builder) {
        builder.comment("The XY positions of on screen elements from the mod").push("Element Positions");
        this.ELEMENT_POSITIONS.spellbar_x = builder.translation("SpellBar X").comment("SpellBar X").define("spellbar_x", (Object)0);
        this.ELEMENT_POSITIONS.spellbar_y = builder.translation("SpellBar X").comment("SpellBar Y").define("spellbar_y", (Object)0);
        this.ELEMENT_POSITIONS.astro_x = builder.translation("Astro X").comment("Astro X").define("astro_x", (Object)0);
        this.ELEMENT_POSITIONS.astro_y = builder.translation("Astro X").comment("Astro Y").define("astro_y", (Object)0);
        this.ELEMENT_POSITIONS.target_x = builder.translation("Target X").comment("Target X").define("target_x", (Object)0);
        this.ELEMENT_POSITIONS.target_y = builder.translation("Target X").comment("Target Y").define("target_y", (Object)0);
        builder.pop().comment("Manages the Earthquake Spell Block Destruction").push("Earthquake");
        this.EARTHQUAKE.enable = builder.translation("Enable").comment("Enable Earthquake Destruction").define("enable", true);
        this.EARTHQUAKE.shake = builder.comment("Enable Screen Shaking").define("shake", true);
        this.EARTHQUAKE.air = builder.translation("Enable Air").comment("If Disabled, destruction stops at the last block rather than setting to air").define("air", true);
        this.EARTHQUAKE.ticks = builder.translation("Destruction Ticks").comment("Amount of Ticks to wait until the next Destruction; Lower = Sooner").defineInRange("ticks", 5, 1, Integer.MAX_VALUE);
        this.EARTHQUAKE.chance = builder.translation("Destruction Chance").comment("Chance that a Destruction will take place; Lower = Higher Chance").defineInRange("chance", 5, 1, Integer.MAX_VALUE);
        this.EARTHQUAKE.destruction = builder.translation("Destruction Order").comment("domain:name|other\n[domain] defaults to `minecraft`\n[other] is what CAN be broken down but won't be broken down into.\n\nExample: [minecraft:gravel|minecraft:grass] may have Cobble before it, so Cobble breaks down into Gravel, which may have Dirt after it so Gravel breaks down into Dirt.\nGrass will also break down into Dirt but Cobble will never break down into Grass.").define("destruction", (Object)Lists.newArrayList((Object[])new String[]{ConfigHandler.getRegName(Blocks.field_150348_b), ConfigHandler.getRegName(Blocks.field_150347_e), ConfigHandler.getRegName(Blocks.field_150351_n) + "|" + ConfigHandler.getRegName(Blocks.field_196658_i) + "|" + ConfigHandler.getRegName(Blocks.field_185774_da) + "|" + ConfigHandler.getRegName(Blocks.field_196660_k), ConfigHandler.getRegName(Blocks.field_150346_d) + "|" + ConfigHandler.getRegName(Blocks.field_150322_A), ConfigHandler.getRegName(Blocks.field_150354_m) + "|" + ConfigHandler.getRegName(Blocks.field_196611_F)}), o -> o instanceof String);
        builder.pop();
        this.maxlevel = builder.translation("Max Level").comment("Sets the maximum level").defineInRange("maxLevel", 15, 1, Integer.MAX_VALUE);
        this.recharge = builder.translation("Recharge Delay").comment("Sets the recharge rate per tick, -1 disables this").define("recharge", (Object)-1);
        this.experience = builder.translation("Enable Vanilla Experience gain").comment("Determines whether or not vanilla experience contributes to AoV experience gain").define("experience", false);
        this.handwrapsSpeed = builder.translation("Speedy Handwraps").comment("Handwraps add +6 to base attack speed").define("handwrapsSpeed", true);
        this.renderBarOverHotbar = builder.translation("Render SpellBar Over HotBar").comment("Sets the Spellbar to render in place of the hotbar while active.").define("renderBarOverHotbar", false);
        this.renderChargesAboveSpellbar = builder.translation("Render Charges Above SpellBar").comment("Renders the Charges left to be above the Spellbar instead of below. This setting has no impact if Render SpellBar Over HotBar is enabled.").define("renderChargesAboveSpellbar", false);
        this.renderAstro = builder.translation("Render Astro UI while Empty").comment("If false, the Astro UI will no longer render while not holding any card, spread, or royal road buff.").define("renderAstro", true);
        this.renderRoyalRoad = builder.translation("Render Royal Road Text").comment("Enables the text render for the Astro UI Royal Road. If disabled, only the icon will render.").define("renderRoyalRoad", true);
        this.renderTarget = builder.translation("Render Target UI").comment("Enables the targetting UI renderer.").define("renderTarget", true);
        this.targetOpacity = builder.translation("Target UI Opcaity").comment("How transparent the target ui is.").defineInRange("targetOpacity", 0.25, 0.0, 1.0);
        this.stencil = builder.translation("Starting Stencil Buffer ref Value").comment("Increase this if you experience weird render issues with this mod and other mods.").defineInRange("stencil", 100, 0, Integer.MAX_VALUE);
        this.centered = builder.translation("Centered Wear").comment("domain:name\ndomain defaults to `minecraft`").defineList("centered", (List)Lists.newArrayList((Object[])new String[]{"aov:handwraps", ConfigHandler.getRegName(Items.field_151041_m), ConfigHandler.getRegName(Items.field_151053_p), ConfigHandler.getRegName(Items.field_151017_I), ConfigHandler.getRegName(Items.field_151039_o), ConfigHandler.getRegName(Items.field_151038_n), ConfigHandler.getRegName(Items.field_151021_T), ConfigHandler.getRegName(Items.field_151027_R), ConfigHandler.getRegName(Items.field_151024_Q), ConfigHandler.getRegName(Items.field_151026_S)}), o -> o instanceof String);
    }

    private static String getRegName(Item item) {
        return Objects.requireNonNull(item.getRegistryName()).func_110623_a();
    }

    private static String getRegName(Block block) {
        return Objects.requireNonNull(block.getRegistryName()).func_110623_a();
    }

    public static void setupCenteredWear() {
        ArrayList list = Lists.newArrayList();
        for (String next : (List)AoV.config.centered.get()) {
            Item item;
            String[] split = next.split(":");
            String domain = "minecraft";
            String regname = split[0];
            if (split.length > 1) {
                domain = split[0];
                regname = split[1];
            }
            if ((item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(domain, regname))) == null || item instanceof ItemAir) continue;
            list.add(item);
        }
        CENTERED_WEAR = ImmutableSet.copyOf((Collection)list);
    }

    private static void update() {
        ConfigHandler.setupCenteredWear();
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("aov")) {
            ConfigHandler.update();
        }
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading event) {
        if (event.getConfig().getModId().equals("aov")) {
            AoV.config.file = (ConfigWrapper)event.getConfig().getConfigData();
            ConfigHandler.update();
        }
    }

    @SubscribeEvent
    public static void onFileChange(ModConfig.ConfigReloading event) {
        if (event.getConfig().getModId().equals("aov")) {
            ConfigHandler.update();
        }
    }

    public static class Earthquake {
        public ForgeConfigSpec.BooleanValue enable;
        public ForgeConfigSpec.BooleanValue shake;
        public ForgeConfigSpec.BooleanValue air;
        public ForgeConfigSpec.IntValue ticks;
        public ForgeConfigSpec.IntValue chance;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> destruction;
    }

    public static class ElementPositions {
        public ForgeConfigSpec.ConfigValue<Integer> spellbar_x;
        public ForgeConfigSpec.ConfigValue<Integer> spellbar_y;
        public ForgeConfigSpec.ConfigValue<Integer> astro_x;
        public ForgeConfigSpec.ConfigValue<Integer> astro_y;
        public ForgeConfigSpec.ConfigValue<Integer> target_x;
        public ForgeConfigSpec.ConfigValue<Integer> target_y;
    }
}

