/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.astro;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.capabilities.stun.IStunCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.entity.EntityCelestialOpposition;
import tamaized.aov.registry.SoundEvents;

public class CelestialOpposition
extends AbilityBase {
    private static final ResourceLocation icon = new ResourceLocation("aov", "textures/spells/celestialopposition.png");
    private static final int charges = -1;
    private static final int distance = 8;

    public CelestialOpposition() {
        super(new TextComponentTranslation(CelestialOpposition.getStaticName(), new Object[0]), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.global.charges", new Object[]{"aov.gui.infinite"}), new TextComponentTranslation("aov.spells.global.range", new Object[]{8}), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.celestialopposition.desc", new Object[0]));
    }

    public static String getStaticName() {
        return "aov.spells.celestialopposition.name";
    }

    @Override
    public ResourceLocation getIcon() {
        return icon;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)CelestialOpposition.getStaticName(), (Object[])new Object[0]);
    }

    @Override
    public int getCoolDown() {
        return 120;
    }

    @Override
    public int getMaxCharges() {
        return -1;
    }

    @Override
    public int getChargeCost() {
        return 0;
    }

    @Override
    public double getMaxDistance() {
        return 8.0;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean isCastOnTarget(EntityPlayer caster, IAoVCapability cap, EntityLivingBase target) {
        return false;
    }

    @Override
    public boolean cast(Ability ability, EntityPlayer caster, EntityLivingBase target) {
        IAoVCapability aov = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.AOV);
        if (!caster.field_70170_p.field_72995_K && aov != null) {
            for (EntityLivingBase e : caster.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(caster.field_70165_t - 8.0, caster.field_70163_u - 8.0, caster.field_70161_v - 8.0, caster.field_70165_t + 8.0, caster.field_70163_u + 8.0, caster.field_70161_v + 8.0))) {
                IStunCapability stun;
                if (e != caster && IAoVCapability.selectiveTarget((Entity)caster, aov, e) && (stun = CapabilityList.getCap((ICapabilityProvider)e, CapabilityList.STUN)) != null) {
                    stun.setStunTicks(160);
                    aov.addExp((Entity)caster, 25, ability.getAbility());
                }
                if (e != caster && !IAoVCapability.canBenefit((Entity)caster, aov, e)) continue;
                for (PotionEffect effect : e.func_70651_bq()) {
                    if (effect.func_188419_a().func_76398_f()) continue;
                    e.func_195064_c(new PotionEffect(effect.func_188419_a(), effect.func_76459_b() + 400, effect.func_76458_c(), effect.func_82720_e(), effect.func_188418_e()));
                }
            }
            EntityCelestialOpposition spell = new EntityCelestialOpposition(caster.field_70170_p);
            spell.func_70107_b(caster.field_70165_t, caster.field_70163_u, caster.field_70161_v);
            caster.field_70170_p.func_72838_d((Entity)spell);
            SoundEvents.playMovingSoundOnServer(SoundEvents.celestialopposition, spell, 0.5f, 1.0f);
            return true;
        }
        return false;
    }
}

