/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.astro;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Particles;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.entity.EntitySpellVanillaParticles;
import tamaized.aov.registry.SoundEvents;

public class EssentialDignity
extends AbilityBase {
    private static final ResourceLocation icon = new ResourceLocation("aov", "textures/spells/essentialdignity.png");
    private static final int charges = -1;
    private static final int distance = 10;

    public EssentialDignity() {
        super(new TextComponentTranslation(EssentialDignity.getStaticName(), new Object[0]), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.global.charges", new Object[]{"aov.gui.infinite"}), new TextComponentTranslation("aov.spells.global.range", new Object[]{10}), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.essentialdignity.desc", new Object[0]));
    }

    public static String getStaticName() {
        return "aov.spells.essentialdignity.name";
    }

    @Override
    public ResourceLocation getIcon() {
        return icon;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)EssentialDignity.getStaticName(), (Object[])new Object[0]);
    }

    @Override
    public int getCoolDown() {
        return 40;
    }

    @Override
    public int getMaxCharges() {
        return -1;
    }

    @Override
    public int getChargeCost() {
        return 0;
    }

    @Override
    public double getMaxDistance() {
        return 10.0;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean isCastOnTarget(EntityPlayer caster, IAoVCapability cap, EntityLivingBase target) {
        return IAoVCapability.canBenefit((Entity)caster, cap, target);
    }

    @Override
    public boolean cast(Ability ability, EntityPlayer caster, EntityLivingBase target) {
        IAoVCapability cap = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.AOV);
        if (cap == null) {
            return false;
        }
        EntityPlayer entity = target != null && IAoVCapability.canBenefit((Entity)caster, cap, target) ? target : caster;
        entity.func_70691_i(entity.func_110138_aP());
        SoundEvents.playMovingSoundOnServer(SoundEvents.essentialdignity, (Entity)entity);
        entity.field_70170_p.func_72838_d((Entity)new EntitySpellVanillaParticles(entity.field_70170_p, (Entity)entity, (IParticleData)Particles.field_197624_q, 10));
        cap.addExp((Entity)caster, 12, this);
        return true;
    }
}

