/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.astro;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.entity.EntityGravity;
import tamaized.aov.registry.SoundEvents;

public class Gravity
extends AbilityBase {
    private static final ResourceLocation icon = new ResourceLocation("aov", "textures/spells/gravity.png");
    private static final int charges = 8;
    private static final int distance = 25;
    private static final int damage = 5;

    public Gravity() {
        super(new TextComponentTranslation(Gravity.getStaticName(), new Object[0]), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.global.charges", new Object[]{8}), new TextComponentTranslation("aov.spells.global.range", new Object[]{25}), new TextComponentTranslation("aov.spells.global.damage", new Object[]{5}), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.gravity.desc", new Object[0]));
    }

    public static String getStaticName() {
        return "aov.spells.gravity.name";
    }

    @Override
    public ResourceLocation getIcon() {
        return icon;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)Gravity.getStaticName(), (Object[])new Object[0]);
    }

    @Override
    public int getCoolDown() {
        return 6;
    }

    @Override
    public int getMaxCharges() {
        return 8;
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public double getMaxDistance() {
        return 25.0;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean isCastOnTarget(EntityPlayer caster, IAoVCapability cap, EntityLivingBase target) {
        return IAoVCapability.selectiveTarget((Entity)caster, cap, target);
    }

    @Override
    public boolean cast(Ability ability, EntityPlayer caster, EntityLivingBase target) {
        IAoVCapability aov = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.AOV);
        if (!caster.field_70170_p.field_72995_K && aov != null && (target == null || IAoVCapability.selectiveTarget((Entity)caster, aov, target))) {
            int dmg = (int)(5.0f * (1.0f + aov.getSpellPower() / 100.0f));
            EntityGravity spell = target == null ? new EntityGravity(caster.field_70170_p, (Entity)caster, (float)dmg, 25) : new EntityGravity(caster.field_70170_p, (Entity)caster, (float)dmg, target.func_174791_d());
            caster.field_70170_p.func_72838_d((Entity)spell);
            SoundEvents.playMovingSoundOnServer(SoundEvents.gravity, spell, 2.0f, 1.0f);
            return true;
        }
        return false;
    }
}

