/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.astro;

import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.entity.EntitySpellAoVParticles;
import tamaized.aov.proxy.CommonProxy;
import tamaized.aov.registry.SoundEvents;

public class Helios
extends AbilityBase {
    private static final ResourceLocation icon = new ResourceLocation("aov", "textures/spells/helios.png");
    private static final int charges = 4;
    private static final int distance = 20;
    private static final int heal = 2;

    public Helios() {
        super(new TextComponentTranslation(Helios.getStaticName(), new Object[0]), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.global.charges", new Object[]{4}), new TextComponentTranslation("aov.spells.global.range", new Object[]{20}), new TextComponentTranslation("aov.spells.global.healing", new Object[]{2}), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.helios.desc", new Object[0]));
    }

    public static String getStaticName() {
        return "aov.spells.helios.name";
    }

    @Override
    public ResourceLocation getIcon() {
        return icon;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)Helios.getStaticName(), (Object[])new Object[0]);
    }

    @Override
    public int getCoolDown() {
        return 4;
    }

    @Override
    public int getMaxCharges() {
        return 4;
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public double getMaxDistance() {
        return 20.0;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean isCastOnTarget(EntityPlayer caster, IAoVCapability cap, EntityLivingBase target) {
        return false;
    }

    @Override
    public boolean cast(Ability ability, EntityPlayer caster, EntityLivingBase target) {
        IAoVCapability cap = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.AOV);
        if (cap == null) {
            return false;
        }
        EntityPlayer e = target != null && IAoVCapability.canBenefit((Entity)caster, cap, target) ? target : caster;
        List list = e.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(e.func_180425_c().func_177982_a(-20, -20, -20), e.func_180425_c().func_177982_a(20, 20, 20)));
        for (EntityLivingBase entity : list) {
            if (entity == caster || IAoVCapability.canBenefit((Entity)caster, cap, entity)) {
                entity.func_70691_i(2.0f);
                entity.field_70170_p.func_72838_d((Entity)new EntitySpellAoVParticles(entity.field_70170_p, (Entity)entity, CommonProxy.ParticleType.Heart, 1073703679, 2));
            }
            cap.addExp((Entity)caster, 12, this);
        }
        SoundEvents.playMovingSoundOnServer(SoundEvents.helios, (Entity)e);
        return true;
    }
}

