/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.astro;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.capabilities.astro.IAstroCapability;
import tamaized.aov.common.core.abilities.Abilities;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;

public class Redraw
extends AbilityBase {
    private static final ResourceLocation icon = new ResourceLocation("aov", "textures/spells/redraw.png");
    private static final int charges = -1;

    public Redraw() {
        super(new TextComponentTranslation(Redraw.getStaticName(), new Object[0]), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.redraw.desc", new Object[0]));
    }

    public static String getStaticName() {
        return "aov.spells.redraw.name";
    }

    @Override
    public ResourceLocation getIcon() {
        return icon;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)Redraw.getStaticName(), (Object[])new Object[0]);
    }

    @Override
    public int getCoolDown() {
        return 30;
    }

    @Override
    public int getMaxCharges() {
        return -1;
    }

    @Override
    public int getChargeCost() {
        return 0;
    }

    @Override
    public double getMaxDistance() {
        return 0.0;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean isCastOnTarget(EntityPlayer caster, IAoVCapability cap, EntityLivingBase target) {
        return false;
    }

    @Override
    public boolean cast(Ability ability, EntityPlayer caster, EntityLivingBase target) {
        IAstroCapability astro = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.ASTRO);
        IAoVCapability aov = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.AOV);
        if (astro == null || aov == null) {
            return false;
        }
        if (astro.getDraw() != null) {
            astro.redrawCard((EntityLivingBase)caster);
            for (Ability a : aov.getSlots()) {
                if (a == null || a.getAbility() != Abilities.draw) continue;
                a.setTimer(30);
            }
            aov.addExp((Entity)caster, 8, ability.getAbility());
        } else {
            ability.setNextCooldown(1);
        }
        astro.sendPacketUpdates(caster);
        return true;
    }
}

