/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.cleric;

import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.helper.ParticleHelper;
import tamaized.aov.proxy.CommonProxy;
import tamaized.aov.registry.AoVDamageSource;
import tamaized.aov.registry.SoundEvents;

public abstract class CureWounds
extends AbilityBase {
    private final String name;
    private final int damage;
    private final int charges;
    private final double range;

    public CureWounds(String n, int c, double r, int dmg) {
        super(new TextComponentTranslation(n, new Object[0]), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.global.charges", new Object[]{c}), new TextComponentTranslation("aov.spells.global.range", new Object[]{r}), new TextComponentTranslation("aov.spells.global.healing", new Object[]{dmg}), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.curewounds.desc", new Object[0]));
        this.name = n;
        this.damage = dmg;
        this.charges = c;
        this.range = r;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)this.name, (Object[])new Object[0]);
    }

    @Override
    public double getMaxDistance() {
        return this.range;
    }

    @Override
    public int getMaxCharges() {
        return this.charges;
    }

    @Override
    public boolean usesInvoke() {
        return true;
    }

    @Override
    public boolean isCastOnTarget(EntityPlayer caster, IAoVCapability cap, EntityLivingBase target) {
        return IAoVCapability.canBenefit((Entity)caster, cap, target);
    }

    protected abstract int getParticleColor();

    @Override
    public boolean cast(Ability ability, EntityPlayer caster, EntityLivingBase e) {
        IAoVCapability cap = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.AOV);
        if (cap == null) {
            return false;
        }
        int a = (int)((float)this.damage * (1.0f + cap.getSpellPower() / 100.0f));
        if (cap.getInvokeMass()) {
            this.castAsMass((EntityLivingBase)caster, a, cap);
        } else if (e == null) {
            caster.func_70691_i((float)a);
            SoundEvents.playMovingSoundOnServer(SoundEvents.heal, (Entity)caster);
        } else {
            this.heal(e, (EntityLivingBase)caster, a, cap);
        }
        cap.addExp((Entity)caster, 24, this);
        return true;
    }

    private void castAsMass(EntityLivingBase caster, int dmg, IAoVCapability cap) {
        int range = (int)(this.getMaxDistance() * 2.0);
        ParticleHelper.spawnParticleMesh(ParticleHelper.MeshType.BURST, CommonProxy.ParticleType.Heart, caster.field_70170_p, caster.func_174791_d(), range, this.getParticleColor());
        List list = caster.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(caster.func_180425_c().func_177982_a(-range, -range, -range), caster.func_180425_c().func_177982_a(range, range, range)));
        for (EntityLivingBase entity : list) {
            this.heal(entity, caster, dmg, cap);
            cap.addExp((Entity)caster, 24, this);
        }
    }

    private void heal(EntityLivingBase entity, EntityLivingBase caster, int dmg, IAoVCapability cap) {
        if (entity.func_70662_br()) {
            entity.func_70097_a(AoVDamageSource.createEntityDamageSource(DamageSource.field_76376_m, (Entity)caster), (float)dmg);
            SoundEvents.playMovingSoundOnServer(SoundEvents.heal, (Entity)entity);
        } else if (IAoVCapability.canBenefit((Entity)caster, cap, entity)) {
            entity.func_70691_i((float)dmg);
            SoundEvents.playMovingSoundOnServer(SoundEvents.heal, (Entity)entity);
        }
    }
}

