/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.druid;

import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.helper.ParticleHelper;
import tamaized.aov.proxy.CommonProxy;

public class DruidicRegenerate
extends AbilityBase {
    private static final String UNLOC = "aov.spells.druidregenerate";
    private static final int CHARGES = 10;
    private static final float RANGE = 6.0f;
    private static final ResourceLocation ICON = new ResourceLocation("aov", "textures/spells/druidicregenerate.png");

    public DruidicRegenerate() {
        super(new TextComponentTranslation(UNLOC.concat(".name"), new Object[0]), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.global.charges", new Object[]{10}), new TextComponentTranslation("aov.spells.global.range", new Object[]{Float.valueOf(6.0f)}), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation(UNLOC.concat(".desc"), new Object[0]));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)UNLOC.concat(".name"), (Object[])new Object[0]);
    }

    @Override
    public int getMaxCharges() {
        return 10;
    }

    @Override
    public int getExtraCharges(EntityLivingBase entity, IAoVCapability cap) {
        return IAoVCapability.isImprovedCentered(entity, cap) ? this.getMaxCharges() : super.getExtraCharges(entity, cap);
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public double getMaxDistance() {
        return 6.0;
    }

    @Override
    public int getCoolDown() {
        return 3;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean isCastOnTarget(EntityPlayer caster, IAoVCapability cap, EntityLivingBase target) {
        return false;
    }

    @Override
    public boolean cast(Ability ability, EntityPlayer caster, EntityLivingBase target) {
        IAoVCapability cap = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.AOV);
        if (cap != null) {
            int range = (int)(this.getMaxDistance() * 2.0);
            List list = caster.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(caster.func_180425_c().func_177982_a(-range, -range, -range), caster.func_180425_c().func_177982_a(range, range, range)));
            for (EntityLivingBase entity : list) {
                entity.func_195064_c(new PotionEffect(MobEffects.field_76428_l, 200, IAoVCapability.isImprovedCentered((EntityLivingBase)caster, cap) ? 1 : 0));
                cap.addExp((Entity)caster, 15, this);
            }
            ParticleHelper.spawnParticleMesh(ParticleHelper.MeshType.BURST, CommonProxy.ParticleType.Heart, caster.field_70170_p, caster.func_174791_d(), range, 0xFFAAFF);
            caster.field_70170_p.func_184148_a(null, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, SoundEvents.field_191244_bn, SoundCategory.PLAYERS, 1.0f, caster.func_70681_au().nextFloat() * 0.5f + 0.5f);
            return true;
        }
        return false;
    }

    @Override
    public ResourceLocation getIcon() {
        return ICON;
    }
}

