/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.druid;

import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.capabilities.polymorph.IPolymorphCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.registry.AoVDamageSource;

public class FuriousHowl
extends AbilityBase {
    private static final String UNLOC = "aov.spells.furioushowl";
    private static final int RANGE = 6;
    private static final float DAMAGE = 2.0f;
    private static final int CHARGES = 5;
    private static final ResourceLocation ICON = new ResourceLocation("aov", "textures/spells/furioushowl.png");

    public FuriousHowl() {
        super(new TextComponentTranslation(UNLOC.concat(".name"), new Object[0]), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.global.charges", new Object[]{5}), new TextComponentTranslation("aov.spells.global.range", new Object[]{6}), new TextComponentTranslation("aov.spells.global.damage", new Object[]{Float.valueOf(2.0f)}), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation(UNLOC.concat(".desc"), new Object[0]));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)UNLOC.concat(".name"), (Object[])new Object[0]);
    }

    @Override
    public int getMaxCharges() {
        return 5;
    }

    @Override
    public int getExtraCharges(EntityLivingBase entity, IAoVCapability cap) {
        return IAoVCapability.isImprovedCentered(entity, cap) ? this.getMaxCharges() : super.getExtraCharges(entity, cap);
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public double getMaxDistance() {
        return 6.0;
    }

    @Override
    public int getCoolDown() {
        return 30;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean isCastOnTarget(EntityPlayer caster, IAoVCapability cap, EntityLivingBase target) {
        return false;
    }

    @Override
    public boolean shouldDisable(@Nullable EntityPlayer caster, IAoVCapability cap) {
        IPolymorphCapability poly = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.POLYMORPH);
        return poly == null || poly.getMorph() != IPolymorphCapability.Morph.Wolf;
    }

    @Override
    public boolean cast(Ability ability, EntityPlayer caster, EntityLivingBase target) {
        IAoVCapability aov = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.AOV);
        IPolymorphCapability cap = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.POLYMORPH);
        if (aov == null || cap == null || cap.getMorph() != IPolymorphCapability.Morph.Wolf) {
            return false;
        }
        float damage = 2.0f * (1.0f + aov.getSpellPower() * (IAoVCapability.isImprovedCentered((EntityLivingBase)caster, aov) ? 2.0f : 1.0f) / 100.0f);
        for (EntityLivingBase entity : caster.field_70170_p.func_175647_a(EntityLivingBase.class, new AxisAlignedBB(caster.func_180425_c().func_177982_a(-6, -6, -6), caster.func_180425_c().func_177982_a(6, 6, 6)), e -> e != caster)) {
            if (!IAoVCapability.selectiveTarget((Entity)caster, aov, entity) || !entity.func_70097_a(AoVDamageSource.createEntityDamageSource(DamageSource.field_76376_m, (Entity)caster), damage)) continue;
            aov.addExp((Entity)caster, 20, this);
        }
        for (int i = 0; i < 3; ++i) {
            caster.field_70170_p.func_184148_a(null, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, SoundEvents.field_187861_gG, SoundCategory.PLAYERS, 0.5f, caster.func_70681_au().nextFloat() * 0.75f + 0.25f);
        }
        return true;
    }

    @Override
    public ResourceLocation getIcon() {
        return ICON;
    }
}

