/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.druid;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.entity.EntitySpellLightningBolt;
import tamaized.aov.common.helper.UtilHelper;

public class LightningStrike
extends AbilityBase {
    private static final String UNLOC = "aov.spells.litstrike";
    private static final float DAMAGE = 5.0f;
    private static final int RANGE = 40;
    private static final int CHARGES = 10;
    private static final ResourceLocation ICON = new ResourceLocation("aov", "textures/spells/lightningstrike.png");

    public LightningStrike() {
        super(new TextComponentTranslation(UNLOC.concat(".name"), new Object[0]), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.global.charges", new Object[]{10}), new TextComponentTranslation("aov.spells.global.range", new Object[]{40}), new TextComponentTranslation("aov.spells.global.damage", new Object[]{Float.valueOf(5.0f)}), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation(UNLOC.concat(".desc"), new Object[0]));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)UNLOC.concat(".name"), (Object[])new Object[0]);
    }

    @Override
    public int getMaxCharges() {
        return 10;
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public double getMaxDistance() {
        return 40.0;
    }

    @Override
    public int getCoolDown() {
        return 15;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean isCastOnTarget(EntityPlayer caster, IAoVCapability cap, EntityLivingBase target) {
        return IAoVCapability.selectiveTarget((Entity)caster, cap, target);
    }

    @Override
    public boolean cast(Ability ability, EntityPlayer caster, EntityLivingBase target) {
        IAoVCapability cap = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.AOV);
        if (cap == null) {
            return false;
        }
        float damage = 5.0f * (1.0f + cap.getSpellPower() / 100.0f);
        EntitySpellLightningBolt strike = new EntitySpellLightningBolt(caster.field_70170_p, (EntityLivingBase)caster, damage, this);
        Vec3d pos = UtilHelper.getSpellLocation(caster, 40, (Entity)target);
        strike.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        caster.field_70170_p.func_72838_d((Entity)strike);
        return true;
    }

    @Override
    public ResourceLocation getIcon() {
        return ICON;
    }
}

