/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.favoredsoul;

import java.util.Locale;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.entity.EntityAlignmentAoE;
import tamaized.aov.registry.SoundEvents;

public class AlignmentAoE
extends AbilityBase {
    private static final int charges = 4;
    private static final int distance = 25;
    private static final int damage = 5;
    private final Type type;

    public AlignmentAoE(Type type) {
        super(new TextComponentTranslation("aov.spells." + type.name().toLowerCase(Locale.US) + ".name", new Object[0]), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.global.charges", new Object[]{4}), new TextComponentTranslation("aov.spells.global.range", new Object[]{25}), new TextComponentTranslation("aov.spells.global.damage", new Object[]{5}), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells." + type.name().toLowerCase(Locale.US) + ".desc", new Object[0]));
        this.type = type;
    }

    @Override
    public ResourceLocation getIcon() {
        return this.type.icon;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)("aov.spells." + this.type.name().toLowerCase(Locale.US) + ".name"), (Object[])new Object[0]);
    }

    @Override
    public int getCoolDown() {
        return 25;
    }

    @Override
    public int getMaxCharges() {
        return 4;
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public double getMaxDistance() {
        return 25.0;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean isCastOnTarget(EntityPlayer caster, IAoVCapability cap, EntityLivingBase target) {
        return IAoVCapability.selectiveTarget((Entity)caster, cap, target);
    }

    @Override
    public boolean cast(Ability ability, EntityPlayer caster, EntityLivingBase target) {
        IAoVCapability aov = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.AOV);
        if (!caster.field_70170_p.field_72995_K && aov != null && (target == null || IAoVCapability.selectiveTarget((Entity)caster, aov, target))) {
            int dmg = (int)(5.0f * (1.0f + aov.getSpellPower() / 100.0f));
            EntityAlignmentAoE spell = target == null ? new EntityAlignmentAoE(caster.field_70170_p, this.type, (Entity)caster, (float)dmg, 25) : new EntityAlignmentAoE(caster.field_70170_p, this.type, (Entity)caster, (float)dmg, target.func_174791_d());
            caster.field_70170_p.func_72838_d((Entity)spell);
            SoundEvents.playMovingSoundOnServer(this.type.sound, spell, 2.0f, this.type.minPitch + caster.func_70681_au().nextFloat() * 0.5f);
            return true;
        }
        return false;
    }

    public static enum Type {
        ChaosHammer(new ResourceLocation("aov", "textures/spells/chaoshammer.png"), SoundEvents.chaosHammer, 1.0f),
        OrdersWrath(new ResourceLocation("aov", "textures/spells/orderswrath.png"), SoundEvents.ordersWrath, 0.5f);

        public static final Type[] values;
        final ResourceLocation icon;
        final SoundEvent sound;
        final float minPitch;

        private Type(ResourceLocation resourceLocation, SoundEvent sound, float pitch) {
            this.icon = resourceLocation;
            this.sound = sound;
            this.minPitch = pitch;
        }

        public static Type getTypeFromID(int id) {
            return id >= values.length || id < 0 ? null : values[id];
        }

        static {
            values = Type.values();
        }
    }
}

