/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.favoredsoul;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.entity.EntitySpellBladeBarrier;

public class BladeBarrier
extends AbilityBase {
    private static final ResourceLocation icon = new ResourceLocation("aov", "textures/spells/bladebarrier.png");
    private static final int damage = 5;
    private static final int charges = 5;
    private static final int distance = 4;

    public BladeBarrier() {
        super(new TextComponentTranslation(BladeBarrier.getStaticName(), new Object[0]), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.global.charges", new Object[]{5}), new TextComponentTranslation("aov.spells.global.range", new Object[]{4}), new TextComponentTranslation("aov.spells.global.damage", new Object[]{5}), new TextComponentTranslation("", new Object[0]), new TextComponentTranslation("aov.spells.bladebarrier.desc", new Object[0]));
    }

    public static String getStaticName() {
        return "aov.spells.bladebarrier.name";
    }

    @Override
    public ResourceLocation getIcon() {
        return icon;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)BladeBarrier.getStaticName(), (Object[])new Object[0]);
    }

    @Override
    public int getCoolDown() {
        return 8;
    }

    @Override
    public int getMaxCharges() {
        return 5;
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public double getMaxDistance() {
        return 4.0;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean isCastOnTarget(EntityPlayer caster, IAoVCapability cap, EntityLivingBase target) {
        return false;
    }

    @Override
    public boolean cast(Ability ability, EntityPlayer caster, EntityLivingBase target) {
        IAoVCapability cap = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.AOV);
        if (cap == null) {
            return false;
        }
        int a = (int)(5.0f * (1.0f + cap.getSpellPower() / 100.0f));
        caster.field_70170_p.func_72838_d((Entity)new EntitySpellBladeBarrier(caster.field_70170_p, (Entity)caster, a, 4));
        return true;
    }
}

