/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.skills;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.core.skills.AoVSkills;

public class AoVSkill {
    private final List<AbilityBase> abilities;
    private final List<TextComponentTranslation> description = Lists.newArrayList();
    private final TextComponentTranslation name;
    private final ResourceLocation icon;
    private final int level;
    private final int spentpoints;
    private final int charges;
    private final int cost;
    private final int spellpower;
    private final int dodge;
    private final int doublestrike;
    private final boolean core;
    private final AoVSkill parent;

    public AoVSkill(TextComponentTranslation name, ResourceLocation icon, int level, int spentpoints, int charges, int cost, int spellpower, int dodge, int doublestrike, boolean core, AoVSkill parent, List<AbilityBase> spells, TextComponentTranslation ... desc) {
        this.name = name;
        this.icon = icon;
        this.level = level;
        this.spentpoints = spentpoints;
        this.charges = charges;
        this.cost = cost;
        this.spellpower = spellpower;
        this.dodge = dodge;
        this.doublestrike = doublestrike;
        this.core = core;
        this.parent = parent;
        this.abilities = spells;
    }

    public AoVSkill setupTooltip(TextComponentTranslation desc) {
        this.description.clear();
        this.description.add(this.name);
        if (this.isClassCore()) {
            this.description.add(new TextComponentTranslation("aov.skill.global.core", new Object[0]));
            this.description.add(new TextComponentTranslation("", new Object[0]));
        }
        if (this.getCharges() > 0) {
            this.description.add(new TextComponentTranslation("aov.skill.global.charge", new Object[]{this.getCharges()}));
        }
        if (this.spellpower > 0) {
            this.description.add(new TextComponentTranslation("aov.skill.global.spellpower", new Object[]{this.spellpower}));
        }
        if (this.dodge > 0) {
            this.description.add(new TextComponentTranslation("aov.skill.global.dodge", new Object[]{this.dodge}));
        }
        if (this.doublestrike > 0) {
            this.description.add(new TextComponentTranslation("aov.skill.global.doublestrike", new Object[]{this.doublestrike}));
        }
        if (!this.isClassCore()) {
            this.description.add(new TextComponentTranslation("", new Object[0]));
            if (this.level > 0) {
                this.description.add(new TextComponentTranslation("aov.skill.global.minlevel", new Object[]{this.level}));
            }
            if (this.spentpoints > 0) {
                this.description.add(new TextComponentTranslation("aov.skill.global.minpoint", new Object[]{this.spentpoints}));
            }
            if (this.parent != null) {
                this.description.add(new TextComponentTranslation("aov.skill.global.parent", new Object[]{this.parent.getName().func_150268_i()}));
            }
        }
        if (desc != null) {
            this.description.add(new TextComponentTranslation("", new Object[0]));
            this.description.add(desc);
        }
        return this;
    }

    public final int getID() {
        return AoVSkills.getID(this);
    }

    public TextComponentTranslation getName() {
        return this.name;
    }

    public final List<AbilityBase> getAbilities() {
        return this.abilities;
    }

    public int getCharges() {
        return this.charges;
    }

    public int getSpellPower() {
        return this.spellpower;
    }

    public int getDodge() {
        return this.dodge;
    }

    public int getDoubleStrike() {
        return this.doublestrike;
    }

    public boolean isClassCore() {
        return this.core;
    }

    public AoVSkill getParent() {
        return this.parent;
    }

    public int getCost() {
        return this.cost;
    }

    public int getLevel() {
        return this.level;
    }

    public int getSpentPoints() {
        return this.spentpoints;
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    @OnlyIn(value=Dist.CLIENT)
    public final List<String> getDescription() {
        ArrayList list = Lists.newArrayList();
        for (TextComponentTranslation s : this.description) {
            Object[] args = new Object[s.func_150271_j().length];
            for (int index = 0; index < args.length; ++index) {
                args[index] = I18n.func_135052_a((String)String.valueOf(s.func_150271_j()[index]), (Object[])new Object[0]);
            }
            list.add(I18n.func_135052_a((String)s.func_150268_i(), (Object[])args));
        }
        return list;
    }
}

