/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.registries.ForgeRegistries;
import tamaized.aov.AoV;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Abilities;
import tamaized.aov.registry.AoVDamageSource;
import tamaized.aov.registry.AoVEntities;

public class EntityEarthquake
extends Entity {
    public List<Quake> quakes = Lists.newArrayList((Object[])new Quake[]{new Quake()});
    private float damage = 1.0f;
    private Entity caster;
    private UUID casterID;

    public EntityEarthquake(World worldIn) {
        super(Objects.requireNonNull(AoVEntities.entityearthquake), worldIn);
        this.func_70105_a(6.0f, 0.1f);
    }

    public EntityEarthquake(World worldIn, Entity caster, float damage) {
        this(worldIn);
        this.caster = caster;
        this.damage = damage;
    }

    private static IBlockState checkDestruction(String check) {
        int index = 0;
        for (String compare : (List)AoV.config.EARTHQUAKE.destruction.get()) {
            ++index;
            for (String c : compare.split("\\|")) {
                Block block;
                if (!c.equalsIgnoreCase(check)) continue;
                if (index >= ((List)AoV.config.EARTHQUAKE.destruction.get()).size()) {
                    return Blocks.field_150350_a.func_176223_P();
                }
                String[] next = ((String)((List)AoV.config.EARTHQUAKE.destruction.get()).get(index)).split("\\|")[0].split(":");
                if (next.length < 2) {
                    next = new String[]{"minecraft", next[0]};
                }
                if ((block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(next[0], next[1]))) == null) {
                    return null;
                }
                return block.func_176223_P();
            }
        }
        return null;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa % 35 == 0) {
                this.quakes.add(new Quake());
            }
            if (this.field_70173_aa % 40 == 0 && this.field_70146_Z.nextBoolean()) {
                this.quakes.add(new Quake());
            }
        } else {
            if (this.field_70170_p.func_175623_d(this.func_180425_c().func_177977_b())) {
                for (int i = this.func_180425_c().func_177977_b().func_177956_o(); i >= 0; --i) {
                    if (i <= 0) {
                        this.func_70106_y();
                        return;
                    }
                    if (this.field_70170_p.func_175623_d(new BlockPos(this.func_180425_c().func_177958_n(), i, this.func_180425_c().func_177952_p()))) continue;
                    this.func_70107_b(this.field_70165_t, i + 1, this.field_70161_v);
                    break;
                }
            }
            if ((this.field_70173_aa % 3 == 0 || this.field_70173_aa % 15 == 0 || this.field_70173_aa % 35 == 0) && this.field_70146_Z.nextBoolean()) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187835_fT, SoundCategory.PLAYERS, 2.0f, this.field_70146_Z.nextFloat() * 0.65f + (this.field_70146_Z.nextBoolean() ? 0.75f : 0.1f));
            }
            if (((Boolean)AoV.config.EARTHQUAKE.enable.get()).booleanValue() && this.field_70173_aa % (Integer)AoV.config.EARTHQUAKE.ticks.get() == 0 && this.field_70146_Z.nextInt((Integer)AoV.config.EARTHQUAKE.chance.get()) == 0) {
                IBlockState newState;
                BlockPos pos;
                IBlockState state;
                int radius = 2;
                ArrayList positions = Lists.newArrayList((Iterable)BlockPos.func_177980_a((BlockPos)new BlockPos(this.field_70165_t - 2.0, this.field_70163_u - 1.0, this.field_70161_v - 2.0), (BlockPos)new BlockPos(this.field_70165_t + 2.0, this.field_70163_u, this.field_70161_v + 2.0)));
                int tries = positions.size();
                do {
                    Block block;
                    ResourceLocation regname;
                    if ((regname = (block = (state = this.field_70170_p.func_180495_p(pos = (BlockPos)positions.get(this.field_70146_Z.nextInt(positions.size())))).func_177230_c()).getRegistryName()) == null) {
                        newState = null;
                        continue;
                    }
                    StringBuilder check = new StringBuilder(regname.func_110624_b()).append(":").append(regname.func_110623_a());
                    newState = EntityEarthquake.checkDestruction(check.toString());
                    if (newState != null) break;
                } while (tries-- > 0);
                if (newState != null) {
                    this.field_70170_p.func_175656_a(pos, newState);
                    this.field_70170_p.func_175718_b(2001, pos, Block.func_196246_j((IBlockState)state));
                }
            }
            if (this.field_70173_aa % 20 == 0) {
                if (this.caster == null && this.casterID != null) {
                    for (Entity e : this.field_70170_p.field_72996_f) {
                        if (!e.func_110124_au().equals(this.casterID)) continue;
                        this.caster = e;
                    }
                }
                IAoVCapability cap = CapabilityList.getCap((ICapabilityProvider)this.caster, CapabilityList.AOV);
                for (EntityLivingBase entity : this.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.field_70165_t - (double)this.field_70130_N, this.field_70163_u - 1.0, this.field_70161_v - (double)this.field_70130_N, this.field_70165_t + (double)this.field_70130_N, this.field_70163_u + 3.0, this.field_70161_v + (double)this.field_70130_N))) {
                    if (entity == this.caster || !IAoVCapability.selectiveTarget(this.caster, cap, entity) || !entity.func_70097_a(AoVDamageSource.createEntityDamageSource(DamageSource.field_76376_m, this.caster), this.damage)) continue;
                    entity.func_195064_c(new PotionEffect(MobEffects.field_76421_d, 160));
                    if (cap == null) continue;
                    cap.addExp(this.caster, 20, Abilities.earthquake);
                }
            }
        }
        if (this.field_70173_aa % 400 == 0) {
            this.func_70106_y();
        }
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(@Nonnull NBTTagCompound compound) {
        this.damage = Math.max(1.0f, compound.func_74760_g("damage"));
        if (compound.func_186855_b("casterID")) {
            this.casterID = compound.func_186857_a("casterID");
        }
    }

    protected void func_70014_b(@Nonnull NBTTagCompound compound) {
        if (this.caster != null) {
            compound.func_186854_a("casterID", this.caster.func_110124_au());
        }
        compound.func_74776_a("damage", this.damage);
    }

    public static class Quake {
        static final float WIDTH = 2.5f;
        static final float HEIGHT = 2.5f;
        private static final Random RAND = new Random();
        final int lifespan = RAND.nextInt(80) + 80;
        final Vec3d offset = new Vec3d(Quake.nextAxisOffset() - 1.0, (double)0.01f, Quake.nextAxisOffset() - 1.0);
        final float alphaspeed = RAND.nextFloat() * 0.024f + 0.001f;
        final float rot = RAND.nextFloat() * 360.0f;
        float life = this.lifespan;
        float alpha = 0.0f;

        static double nextAxisOffset() {
            return RAND.nextDouble() * 3.0 - 1.5;
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean render(@Nonnull EntityEarthquake entity, double ox, double oy, double oz, float partialTicks) {
            this.life -= partialTicks;
            if (this.life <= 0.0f) {
                return true;
            }
            float r = 0.2f;
            float g = 0.1f;
            float b = 0.0f;
            if (this.alpha < 1.0f) {
                this.alpha += this.alphaspeed * partialTicks;
            }
            if (this.alpha > 1.0f) {
                this.alpha = 1.0f;
            }
            double x = ox + this.offset.field_72450_a;
            double y = oy + this.offset.field_72448_b;
            double z = oz + this.offset.field_72449_c;
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_181662_b(x, y, z + 2.5).func_187315_a(0.0, 1.0).func_181666_a(r, g, b, this.alpha).func_181675_d();
            buffer.func_181662_b(x + 2.5, y, z + 2.5).func_187315_a(1.0, 1.0).func_181666_a(r, g, b, this.alpha).func_181675_d();
            buffer.func_181662_b(x + 2.5, y, z).func_187315_a(1.0, 0.0).func_181666_a(r, g, b, this.alpha).func_181675_d();
            buffer.func_181662_b(x, y, z).func_187315_a(0.0, 0.0).func_181666_a(r, g, b, this.alpha).func_181675_d();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)ox, (double)oy, (double)oz);
            GlStateManager.func_179114_b((float)this.rot, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)(-ox), (double)(-oy), (double)(-oz));
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_179121_F();
            return false;
        }
    }
}

