/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.entity;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import tamaized.aov.AoV;
import tamaized.aov.proxy.CommonProxy;
import tamaized.aov.registry.AoVEntities;

public class EntitySpellAoVParticles
extends Entity {
    private static final CommonProxy.ParticleType[] particles = CommonProxy.ParticleType.values();
    private static final DataParameter<Integer> PARTICLE = EntityDataManager.func_187226_a(EntitySpellAoVParticles.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntitySpellAoVParticles.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> RATE = EntityDataManager.func_187226_a(EntitySpellAoVParticles.class, (DataSerializer)DataSerializers.field_187192_b);
    private Entity target;
    private int tick = 0;

    public EntitySpellAoVParticles(World worldIn) {
        super(Objects.requireNonNull(AoVEntities.entityspellaovparticles), worldIn);
    }

    public EntitySpellAoVParticles(World world, Entity entity, CommonProxy.ParticleType particle, int color, int rate) {
        this(world);
        this.target = entity;
        this.func_70634_a(this.target.field_70165_t, this.target.field_70163_u, this.target.field_70161_v);
        this.tick = this.field_70146_Z.nextInt(10) + 20;
        this.setParticle(particle);
        this.setColor(color);
        this.field_70180_af.func_187227_b(RATE, (Object)rate);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(PARTICLE, (Object)CommonProxy.ParticleType.Fluff.ordinal());
        this.field_70180_af.func_187214_a(COLOR, (Object)-1);
        this.field_70180_af.func_187214_a(RATE, (Object)10);
    }

    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    public void setColor(int color) {
        this.field_70180_af.func_187227_b(COLOR, (Object)color);
    }

    public CommonProxy.ParticleType getParticle() {
        int index = (Integer)this.field_70180_af.func_187225_a(PARTICLE);
        return index >= 0 && index < particles.length ? particles[index] : CommonProxy.ParticleType.Fluff;
    }

    public void setParticle(CommonProxy.ParticleType particle) {
        this.field_70180_af.func_187227_b(PARTICLE, (Object)particle.ordinal());
    }

    protected void func_70037_a(@Nonnull NBTTagCompound compound) {
        this.field_70180_af.func_187227_b(PARTICLE, (Object)compound.func_74762_e("particle"));
    }

    protected void func_70014_b(@Nonnull NBTTagCompound compound) {
        compound.func_74768_a("particle", ((Integer)this.field_70180_af.func_187225_a(PARTICLE)).intValue());
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            for (int index = 0; index < (Integer)this.field_70180_af.func_187225_a(RATE); ++index) {
                Vec3d vec = this.func_70676_i(1.0f).func_178789_a((float)this.field_70146_Z.nextInt(360)).func_178785_b((float)this.field_70146_Z.nextInt(360));
                Vec3d pos = this.func_174791_d().func_72441_c(0.0, (double)0.65f, 0.0).func_178787_e(vec);
                AoV.proxy.spawnParticle(this.getParticle(), this.field_70170_p, pos, new Vec3d(0.0, 0.0625, 0.0), 16, 0.0f, 1.0f, this.getColor());
            }
            return;
        }
        if (this.tick-- <= 0 || this.target == null || !this.target.func_70089_S()) {
            this.func_70106_y();
            return;
        }
        this.func_70634_a(this.target.field_70165_t, this.target.field_70163_u, this.target.field_70161_v);
    }
}

