/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.entity;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import tamaized.aov.client.particle.ParticleImplosion;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Abilities;
import tamaized.aov.registry.AoVDamageSource;
import tamaized.aov.registry.AoVEntities;

public class EntitySpellImplosion
extends Entity
implements IEntityAdditionalSpawnData {
    private Entity caster;
    private EntityLivingBase target;
    private int tick = 0;

    public EntitySpellImplosion(World worldIn) {
        super(Objects.requireNonNull(AoVEntities.entityspellimplosion), worldIn);
    }

    public EntitySpellImplosion(World world, Entity caster, EntityLivingBase entity) {
        this(world);
        this.caster = caster;
        this.target = entity;
        this.func_70634_a(this.target.field_70165_t, this.target.field_70163_u, this.target.field_70161_v);
        this.tick = this.field_70146_Z.nextInt(80);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeInt(this.target.func_145782_y());
    }

    public void readSpawnData(PacketBuffer additionalData) {
        Entity e = this.field_70170_p.func_73045_a(additionalData.readInt());
        if (e instanceof EntityLivingBase) {
            this.target = (EntityLivingBase)e;
        }
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(@Nonnull NBTTagCompound compound) {
    }

    protected void func_70014_b(@Nonnull NBTTagCompound compound) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            if (this.target != null) {
                for (int i = 0; i < 20; ++i) {
                    Vec3d vec = this.func_70676_i(1.0f).func_178789_a((float)this.field_70146_Z.nextInt(360)).func_178785_b((float)this.field_70146_Z.nextInt(360));
                    float speed = 0.08f;
                    Vec3d pos = this.func_174791_d().func_72441_c(0.0, (double)(this.target.field_70131_O / 2.0f), 0.0).func_178787_e(vec);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleImplosion(this.field_70170_p, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, -vec.field_72450_a * (double)speed, -vec.field_72448_b * (double)speed, -vec.field_72449_c * (double)speed));
                }
            }
            return;
        }
        if (this.target == null || !this.target.func_70089_S()) {
            this.func_70106_y();
            return;
        }
        this.func_70634_a(this.target.field_70165_t, this.target.field_70163_u, this.target.field_70161_v);
        ++this.tick;
        if (this.tick % 100 == 0) {
            float damage = this.field_70146_Z.nextFloat() * this.target.func_110138_aP();
            IAoVCapability cap = CapabilityList.getCap((ICapabilityProvider)this.caster, CapabilityList.AOV);
            if (cap != null) {
                damage *= 1.0f + cap.getSpellPower() / 100.0f;
            }
            this.target.func_70097_a(AoVDamageSource.createEntityDamageSource(AoVDamageSource.DESTRUCTION, this.caster), damage);
            if (cap != null) {
                cap.addExp(this.caster, 25, Abilities.implosion);
            }
            this.func_70106_y();
        }
    }
}

