/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.entity;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Abilities;
import tamaized.aov.common.entity.EntitySpellLightningBolt;
import tamaized.aov.registry.AoVEntities;

public class EntitySpellLightningStorm
extends Entity {
    public final List<Cloud> clouds = Lists.newArrayList();
    private float damage = 1.0f;
    private EntityLivingBase caster;
    private UUID casterID;
    private int nextMod = 30;

    public EntitySpellLightningStorm(World worldIn) {
        super(Objects.requireNonNull(AoVEntities.entityspelllightningstorm), worldIn);
        this.func_70105_a(12.0f, 0.1f);
        this.field_70158_ak = true;
    }

    public EntitySpellLightningStorm(World worldIn, EntityLivingBase caster, float damage) {
        this(worldIn);
        this.caster = caster;
        this.damage = damage;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % this.nextMod == 0) {
            this.nextMod = 20 + this.field_70146_Z.nextInt(30);
            if (this.caster == null && this.casterID != null) {
                for (Entity e2 : this.field_70170_p.field_72996_f) {
                    if (!(e2 instanceof EntityLivingBase) || !e2.func_110124_au().equals(this.casterID)) continue;
                    this.caster = (EntityLivingBase)e2;
                }
            }
            double size = this.field_70130_N / 2.0f;
            List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.field_70165_t - size, this.field_70163_u - 36.0, this.field_70161_v - size, this.field_70165_t + size, this.field_70163_u + 3.0, this.field_70161_v + size));
            list.removeIf(e -> e == this.caster || !IAoVCapability.selectiveTarget((Entity)this.caster, CapabilityList.getCap((ICapabilityProvider)this.caster, CapabilityList.AOV, null), e));
            EntityLivingBase entity = list.isEmpty() ? null : (list.size() == 1 ? (EntityLivingBase)list.get(0) : (EntityLivingBase)list.get(this.field_70146_Z.nextInt(list.size())));
            EntitySpellLightningBolt strike = new EntitySpellLightningBolt(this.field_70170_p, this.caster, this.damage, Abilities.lightningStorm);
            Vec3d vec = entity != null ? entity.func_174791_d() : this.getNextPos();
            strike.func_70107_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            this.field_70170_p.func_72838_d((Entity)strike);
        }
        if (this.field_70173_aa >= 400) {
            this.func_70106_y();
        }
    }

    private double getNextCoord() {
        return this.field_70146_Z.nextDouble() * (double)this.field_70130_N - (double)(this.field_70130_N / 2.0f);
    }

    private Vec3d getNextPos() {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(new BlockPos(this.getNextCoord() + this.field_70165_t, this.field_70163_u, this.getNextCoord() + this.field_70161_v));
        while (pos.func_177956_o() > 1 && this.field_70170_p.func_175623_d((BlockPos)pos)) {
            pos.func_189533_g((Vec3i)pos.func_177977_b());
        }
        return new Vec3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(@Nonnull NBTTagCompound compound) {
        this.damage = Math.max(1.0f, compound.func_74760_g("damage"));
        if (compound.func_186855_b("casterID")) {
            this.casterID = compound.func_186857_a("casterID");
        }
    }

    protected void func_70014_b(@Nonnull NBTTagCompound compound) {
        if (this.caster != null) {
            compound.func_186854_a("casterID", this.caster.func_110124_au());
        }
        compound.func_74776_a("damage", this.damage);
    }

    public static class Cloud {
        static final Random RAND = new Random();
        public Vec3d offset = new Vec3d(Cloud.getNextOffset(), Cloud.getNextOffset(), Cloud.getNextOffset());
        float life;
        float maxLife = this.life = (float)(RAND.nextInt(80) + 60);
        float width = 10.0f + (RAND.nextFloat() * 5.0f - 2.5f);
        float height = 5.0f + (RAND.nextFloat() * 2.5f - 1.25f);
        float rot = RAND.nextFloat() * 45.0f - 22.5f + (float)(RAND.nextBoolean() ? 180 : 0);
        float alpha = 0.0f;

        static double getNextOffset() {
            return RAND.nextDouble() * 5.0 - 2.5;
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean render(@Nonnull EntitySpellLightningStorm entity, double ox, double oy, double oz, float partialTicks, RenderManager renderManager) {
            if (!Minecraft.func_71410_x().func_147113_T()) {
                this.life -= partialTicks;
                this.alpha += (float)(this.life < this.maxLife / 2.0f ? -1 : 1) * partialTicks * (1.0f / (this.maxLife / 2.0f));
                this.alpha = MathHelper.func_76131_a((float)this.alpha, (float)0.0f, (float)1.0f);
            }
            GlStateManager.func_179094_E();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181712_l);
            double x = ox - (double)(this.width / 2.0f) + this.offset.field_72450_a;
            double y = oy - (double)(this.height / 2.0f) + this.offset.field_72448_b;
            double z = oz + this.offset.field_72449_c;
            GlStateManager.func_179137_b((double)ox, (double)oy, (double)oz);
            GlStateManager.func_179114_b((float)(180.0f - renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)(renderManager.field_78733_k.field_74320_O == 2 ? -1 : 1) * -renderManager.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)this.rot, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)(-ox), (double)(-oy), (double)(-oz));
            buffer.func_181662_b(x, y, z).func_187315_a(0.0, 0.0).func_181666_a(0.45f, 0.45f, 0.45f, this.alpha).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            buffer.func_181662_b(x + (double)this.width, y, z).func_187315_a(1.0, 0.0).func_181666_a(0.45f, 0.45f, 0.45f, this.alpha).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            buffer.func_181662_b(x + (double)this.width, y + (double)this.height, z).func_187315_a(1.0, 1.0).func_181666_a(0.05f, 0.15f, 0.05f, this.alpha).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            buffer.func_181662_b(x, y + (double)this.height, z).func_187315_a(0.0, 1.0).func_181666_a(0.05f, 0.15f, 0.05f, this.alpha).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            return this.life <= 0.0f;
        }
    }
}

