/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.entity;

import java.util.Objects;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.entity.ProjectileBase;
import tamaized.aov.registry.AoVDamageSource;
import tamaized.aov.registry.AoVEntities;

public class ProjectileNimbusRay
extends ProjectileBase {
    public ProjectileNimbusRay(World worldIn) {
        super(Objects.requireNonNull(AoVEntities.projectilenimbusray), worldIn);
        this.setDamageRangeSpeed(2.0, 0.0f, 0.0);
    }

    public ProjectileNimbusRay(World world, EntityPlayer shooter, double x, double y, double z) {
        super(Objects.requireNonNull(AoVEntities.projectilenimbusray), world, (EntityLivingBase)shooter, x, y, z);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    @Override
    protected DamageSource getDamageSource() {
        return AoVDamageSource.createEntityDamageSource(AoVDamageSource.NIMBUS, this.field_70250_c);
    }

    @Override
    protected float getDamageAmp(double damage, Entity shooter, Entity target) {
        return (float)(damage * (double)(target instanceof EntityMob && ((EntityMob)target).func_70662_br() ? 2 : 1));
    }

    @Override
    protected void func_184548_a(EntityLivingBase entity) {
        IAoVCapability cap;
        if (this.field_70250_c != null && (cap = CapabilityList.getCap((ICapabilityProvider)this.field_70250_c, CapabilityList.AOV)) != null) {
            cap.addExp(this.field_70250_c, 20, this.getSpell());
        }
    }

    @Override
    protected void blockHit(IBlockState state, BlockPos pos) {
    }
}

