/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.events;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import tamaized.aov.AoV;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.leap.ILeapCapability;
import tamaized.aov.common.capabilities.polymorph.IPolymorphCapability;
import tamaized.aov.common.capabilities.stun.IStunCapability;
import tamaized.aov.proxy.CommonProxy;
import tamaized.aov.registry.AoVPotions;

@Mod.EventBusSubscriber(modid="aov")
public class TickHandler {
    private static final List<UUID> FLYING = Lists.newArrayList();

    private static void spawnSlowfallParticles(EntityLivingBase living) {
        ILeapCapability cap = CapabilityList.getCap((ICapabilityProvider)living, CapabilityList.LEAP);
        if (cap == null || cap.getLeapDuration() <= 0) {
            return;
        }
        float perc = MathHelper.func_76131_a((float)((float)cap.getLeapDuration() / (float)cap.getMaxLeapDuration()), (float)0.0f, (float)1.0f);
        int bound = 100 - (int)(perc * 100.0f) + 1;
        Vec3d pos = living.func_174791_d();
        for (int i = 0; i < 3; ++i) {
            if (living.field_70170_p.field_73012_v.nextInt(bound > 0 ? bound : 1) > 2) continue;
            double yaw = Math.toRadians(living.field_70761_aq + 63.0f);
            float range = 1.0f;
            float r = living.field_70170_p.field_73012_v.nextFloat() * (1.0f + range) - (0.5f + range);
            Vec3d vec = new Vec3d(-Math.cos(yaw), (double)1.7f, -Math.sin(yaw)).func_178785_b(r);
            vec = pos.func_178787_e(vec).func_72441_c(0.0, (double)(living.field_70170_p.field_73012_v.nextFloat() * 0.5f - 0.5f), 0.0);
            AoV.proxy.spawnParticle(CommonProxy.ParticleType.Feather, living.field_70170_p, vec, new Vec3d(0.0, 0.0, 0.0), 55, 0.1f, 1.5f, -65281);
        }
    }

    @SubscribeEvent
    public static void updateLiving(LivingEvent.LivingUpdateEvent e) {
        EntityLivingBase living = e.getEntityLiving();
        IPolymorphCapability poly = CapabilityList.getCap((ICapabilityProvider)living, CapabilityList.POLYMORPH);
        if (poly != null && (poly.getMorph() == IPolymorphCapability.Morph.WaterElemental || poly.getMorph() == IPolymorphCapability.Morph.FireElemental || poly.getMorph() == IPolymorphCapability.Morph.ArchAngel)) {
            for (Potion potion : IPolymorphCapability.ELEMENTAL_IMMUNITY_EFFECTS) {
                living.func_195063_d(potion);
            }
        }
        if (living.field_70170_p.field_72995_K) {
            TickHandler.spawnSlowfallParticles(living);
        } else {
            EntityPlayer player;
            EntityPlayer entityPlayer = player = living instanceof EntityPlayer ? (EntityPlayer)living : null;
            if (player != null) {
                if (poly != null && poly.getMorph() == IPolymorphCapability.Morph.ArchAngel) {
                    player.field_71075_bZ.field_75101_c = true;
                    player.func_71016_p();
                    if (!FLYING.contains(player.func_110124_au())) {
                        FLYING.add(player.func_110124_au());
                    }
                } else if (FLYING.remove(player.func_110124_au()) && !player.func_184812_l_() && !player.func_175149_v()) {
                    player.field_71075_bZ.field_75101_c = false;
                    player.func_71016_p();
                } else if (!(player.func_184812_l_() || player.func_175149_v() || player.field_71075_bZ.field_75101_c)) {
                    player.field_71075_bZ.field_75102_a = false;
                    player.field_71075_bZ.field_75100_b = false;
                    player.func_71016_p();
                }
            }
            ILeapCapability cap = CapabilityList.getCap((ICapabilityProvider)living, CapabilityList.LEAP);
            PotionEffect pot = living.func_70660_b(AoVPotions.slowFall);
            if (pot == null || cap == null) {
                return;
            }
            if (living.field_70173_aa % 20 == 0) {
                cap.setLeapDuration(pot.func_76459_b());
            }
        }
    }

    @SubscribeEvent
    public static void updateEntity(TickEvent.WorldTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            return;
        }
        ArrayList list = Lists.newArrayList((Iterable)e.world.field_72996_f);
        for (Entity entity : list) {
            IStunCapability cap;
            if (!(entity instanceof EntityLivingBase) || entity.field_70128_L || (cap = CapabilityList.getCap((ICapabilityProvider)entity, CapabilityList.STUN)) == null) continue;
            cap.update((EntityLivingBase)entity);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void update(TickEvent.PlayerTickEvent e) {
        Object cap;
        if (e.phase == TickEvent.Phase.START) {
            return;
        }
        EntityPlayer player = e.player;
        if (player.func_110143_aJ() <= player.func_110138_aP() / 2.0f) {
            if (player.func_70660_b(AoVPotions.stalwartPact) != null) {
                player.func_184596_c(AoVPotions.stalwartPact);
                player.func_195064_c(new PotionEffect(MobEffects.field_76444_x, 6000, 2));
                player.func_195064_c(new PotionEffect(MobEffects.field_76428_l, 200, 2));
            }
            if (player.func_70660_b(AoVPotions.naturesBounty) != null) {
                player.func_184596_c(AoVPotions.naturesBounty);
                player.func_195064_c(new PotionEffect(MobEffects.field_76428_l, 200, 2));
            }
        }
        if ((cap = CapabilityList.getCap((ICapabilityProvider)player, CapabilityList.AOV)) != null) {
            cap.update(player);
        }
        if ((cap = CapabilityList.getCap((ICapabilityProvider)player, CapabilityList.ASTRO)) != null) {
            cap.update((EntityLivingBase)player);
        }
        if ((cap = CapabilityList.getCap((ICapabilityProvider)player, CapabilityList.LEAP)) != null) {
            cap.update((EntityLivingBase)player);
        }
        if ((cap = CapabilityList.getCap((ICapabilityProvider)player, CapabilityList.POLYMORPH)) != null) {
            cap.update(player);
        }
    }
}

