/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.gui;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IInteractionObject;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import tamaized.aov.client.gui.AoVSkillsGUI;
import tamaized.aov.client.gui.ResetSkillsGUI;
import tamaized.aov.client.gui.ShowStatsGUI;
import tamaized.aov.client.gui.SpellBookGUI;
import tamaized.aov.common.blocks.BlockAngelicBlock;

public class GuiHandler {
    private static final int GUI_BITS = 15;
    public static final int GUI_BIT_SHIFT = Integer.highestOneBit(15);
    private static IInteractionObject FAKE_CONTAINER = new IInteractionObject(){

        @Nonnull
        public Container func_174876_a(@Nonnull InventoryPlayer inventoryPlayer, @Nonnull EntityPlayer entityPlayer) {
            return new FakeContainer();
        }

        @Nonnull
        public String func_174875_k() {
            return "aov:fake";
        }

        @Nonnull
        public ITextComponent func_200200_C_() {
            return new TextComponentTranslation("fake", new Object[0]);
        }

        public boolean func_145818_k_() {
            return false;
        }

        @Nullable
        public ITextComponent func_200201_e() {
            return null;
        }
    };

    public static void openGui(GUI gui, BlockAngelicBlock.ClassType classType) {
        GuiHandler.openGui((classType.ordinal() << GUI_BIT_SHIFT) + gui.ordinal());
    }

    public static void openGui(GUI gui) {
        GuiHandler.openGui(gui.ordinal());
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void openGui(int gui) {
        Minecraft.func_71410_x().func_147108_a(GuiHandler.getGui(gui));
    }

    public static void openGui(GUI gui, BlockAngelicBlock.ClassType classType, EntityPlayerMP player) {
        GuiHandler.openGui((classType.ordinal() << GUI_BIT_SHIFT) + gui.ordinal(), player);
    }

    public static void openGui(GUI gui, EntityPlayerMP player) {
        GuiHandler.openGui(gui.ordinal(), player);
    }

    private static void openGui(int gui, EntityPlayerMP player) {
        IInteractionObject container = FAKE_CONTAINER;
        NetworkHooks.openGui((EntityPlayerMP)player, (IInteractionObject)container, (T packetBuffer) -> packetBuffer.writeInt(gui));
    }

    public static GuiScreen getGui(FMLPlayMessages.OpenContainer packet) {
        int id = packet.getAdditionalData().readInt();
        return GuiHandler.getGui(id);
    }

    public static GuiScreen getGui(int id) {
        BlockAngelicBlock.ClassType data = BlockAngelicBlock.ClassType.values[id >>> GUI_BIT_SHIFT];
        switch (GUI.values[id & 0xF]) {
            case SKILLS: {
                return new AoVSkillsGUI(data);
            }
            case SPELLBOOK: {
                return new SpellBookGUI(data);
            }
            case CHECKSTATS: {
                return new ShowStatsGUI(data);
            }
            case RESET: {
                return new ResetSkillsGUI(data);
            }
        }
        return null;
    }

    public static class FakeContainer
    extends Container {
        public boolean func_75145_c(@Nonnull EntityPlayer playerIn) {
            return true;
        }
    }

    public static enum GUI {
        SKILLS,
        SPELLBOOK,
        CHECKSTATS,
        RESET;

        public static final GUI[] values;

        static {
            values = GUI.values();
        }
    }
}

