/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class RayTraceHelper {
    private RayTraceHelper() {
    }

    public static Vec3d[] getPlayerTraceVec(EntityPlayer player, int distance) {
        Vec3d vec3d = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        Vec3d vec3d1 = player.func_70676_i(1.0f);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * (double)distance, vec3d1.field_72448_b * (double)distance, vec3d1.field_72449_c * (double)distance);
        return new Vec3d[]{vec3d, vec3d2};
    }

    public static RayTraceResult tracePath(World world, EntityPlayer player, int distance, float size, HashSet<Entity> excluded) {
        Vec3d[] vecs = RayTraceHelper.getPlayerTraceVec(player, distance);
        return RayTraceHelper.tracePath(world, vecs[0], vecs[1], size, excluded);
    }

    public static RayTraceResult tracePath(World world, Vec3d vec1, Vec3d vec2, float size, HashSet<Entity> excluded) {
        return RayTraceHelper.tracePath(world, (float)vec1.field_72450_a, (float)vec1.field_72448_b, (float)vec1.field_72449_c, (float)vec2.field_72450_a, (float)vec2.field_72448_b, (float)vec2.field_72449_c, size, excluded);
    }

    private static RayTraceResult tracePath(World world, float x, float y, float z, float tx, float ty, float tz, float size, HashSet<Entity> excluded) {
        Vec3d startVec = new Vec3d((double)x, (double)y, (double)z);
        Vec3d endVec = new Vec3d((double)tx, (double)ty, (double)tz);
        float minX = x < tx ? x : tx;
        float minY = y < ty ? y : ty;
        float minZ = z < tz ? z : tz;
        float maxX = x > tx ? x : tx;
        float maxY = y > ty ? y : ty;
        float maxZ = z > tz ? z : tz;
        AxisAlignedBB bb = new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ).func_72314_b((double)size, (double)size, (double)size);
        ArrayList allEntities = excluded == null ? Lists.newArrayList() : world.func_72839_b(null, bb);
        RayTraceResult blockHit = world.func_72933_a(startVec, endVec);
        startVec = new Vec3d((double)x, (double)y, (double)z);
        endVec = new Vec3d((double)tx, (double)ty, (double)tz);
        Entity closestHitEntity = null;
        float closestHit = Float.POSITIVE_INFINITY;
        for (Entity ent : allEntities) {
            float currentHit;
            if (!ent.func_70067_L() || excluded.contains(ent)) continue;
            float entBorder = ent.func_70111_Y();
            AxisAlignedBB entityBb = ent.func_174813_aQ();
            RayTraceResult intercept = (entityBb = entityBb.func_72314_b((double)entBorder, (double)entBorder, (double)entBorder)).func_72327_a(startVec, endVec);
            if (intercept == null || !((currentHit = (float)intercept.field_72307_f.func_72438_d(startVec)) < closestHit) && currentHit != 0.0f) continue;
            closestHit = currentHit;
            closestHitEntity = ent;
        }
        if (closestHitEntity != null && (blockHit == null || blockHit.field_72313_a != RayTraceResult.Type.BLOCK || closestHitEntity.func_70011_f((double)x, (double)y, (double)z) <= startVec.func_72438_d(blockHit.field_72307_f))) {
            blockHit = new RayTraceResult(closestHitEntity);
        }
        return blockHit;
    }
}

