/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.network.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.capabilities.polymorph.IPolymorphCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.core.abilities.Aura;
import tamaized.aov.common.core.skills.AoVSkill;
import tamaized.aov.common.core.skills.AoVSkills;
import tamaized.aov.network.NetworkMessages;

public class ClientPacketHandlerAoVData
implements NetworkMessages.IMessage<ClientPacketHandlerAoVData> {
    private List<AoVSkill> obtainedSkills;
    private int skillPoints;
    private int exp;
    private int maxLevel;
    private boolean invokeMass;
    private Ability[] slots;
    private int currentSlot;
    private IPolymorphCapability.Morph polymorph;
    private byte renderBits;
    private Map<AbilityBase, Integer> cooldowns;
    private List<Aura> auras;

    public ClientPacketHandlerAoVData(IAoVCapability cap, IPolymorphCapability poly) {
        this.obtainedSkills = cap.getObtainedSkills();
        this.skillPoints = cap.getSkillPoints();
        this.exp = cap.getExp();
        this.maxLevel = cap.getMaxLevel();
        this.invokeMass = cap.getInvokeMass();
        this.slots = cap.getSlots();
        this.currentSlot = cap.getCurrentSlot();
        this.cooldowns = cap.getCooldowns();
        this.polymorph = poly.getMorph();
        this.renderBits = poly.getFlagBits();
        this.auras = cap.getAuras();
    }

    @Override
    public void handle(EntityPlayer player) {
        IPolymorphCapability poly;
        IAoVCapability cap = CapabilityList.getCap((ICapabilityProvider)player, CapabilityList.AOV);
        if (cap != null) {
            cap.getObtainedSkills().clear();
            for (AoVSkill skill : this.obtainedSkills) {
                cap.addObtainedSkill(skill);
            }
            cap.setSkillPoints(this.skillPoints);
            cap.setExp(this.exp);
            cap.setMaxLevel(this.maxLevel);
            cap.toggleInvokeMass(this.invokeMass);
            for (int index = 0; index < 9; ++index) {
                cap.setSlot(this.slots[index], index, true);
            }
            cap.setCurrentSlot(this.currentSlot);
            cap.setCooldowns(Collections.unmodifiableMap(this.cooldowns));
            cap.clearAuras();
            for (Aura aura : this.auras) {
                cap.addAura(aura);
            }
            cap.markDirty();
            cap.setLoaded();
        }
        if ((poly = CapabilityList.getCap((ICapabilityProvider)player, CapabilityList.POLYMORPH)) != null) {
            poly.morph(this.polymorph);
            poly.setFlagBits(this.renderBits);
        }
    }

    @Override
    public void toBytes(PacketBuffer packet) {
        packet.writeInt(this.obtainedSkills.size());
        for (AoVSkill skill : this.obtainedSkills) {
            packet.writeInt(skill == null ? -1 : skill.getID());
        }
        packet.writeInt(this.skillPoints);
        packet.writeInt(this.exp);
        packet.writeInt(this.maxLevel);
        packet.writeBoolean(this.invokeMass);
        for (int index = 0; index < 9; ++index) {
            Ability ability = this.slots[index];
            if (ability == null) {
                packet.writeBoolean(false);
                continue;
            }
            packet.writeBoolean(true);
            ability.encode((ByteBuf)packet);
        }
        packet.writeInt(this.currentSlot);
        packet.writeInt(this.cooldowns.size());
        for (Map.Entry<AbilityBase, Integer> entry : this.cooldowns.entrySet()) {
            packet.writeInt(entry.getKey().getID());
            packet.writeInt(entry.getValue().intValue());
        }
        packet.writeInt(this.polymorph == null ? -1 : this.polymorph.ordinal());
        packet.writeByte((int)this.renderBits);
        packet.writeInt(this.auras.size());
        for (Aura aura : this.auras) {
            aura.encode((ByteBuf)packet);
        }
    }

    @Override
    public ClientPacketHandlerAoVData fromBytes(PacketBuffer packet) {
        int index;
        this.obtainedSkills = Lists.newArrayList();
        int size = packet.readInt();
        for (index = 0; index < size; ++index) {
            this.obtainedSkills.add(AoVSkills.getSkillFromID(packet.readInt()));
        }
        this.skillPoints = packet.readInt();
        this.exp = packet.readInt();
        this.maxLevel = packet.readInt();
        this.invokeMass = packet.readBoolean();
        this.slots = new Ability[9];
        for (index = 0; index < 9; ++index) {
            this.slots[index] = packet.readBoolean() ? Ability.construct((ByteBuf)packet) : null;
        }
        this.currentSlot = packet.readInt();
        this.cooldowns = Maps.newHashMap();
        size = packet.readInt();
        for (index = 0; index < size; ++index) {
            this.cooldowns.put(AbilityBase.getAbilityFromID(packet.readInt()), packet.readInt());
        }
        this.polymorph = IPolymorphCapability.Morph.getMorph(packet.readInt());
        this.renderBits = packet.readByte();
        this.auras = Lists.newArrayList();
        size = packet.readInt();
        for (index = 0; index < size; ++index) {
            this.auras.add(Aura.construct((ByteBuf)packet));
        }
        return this;
    }
}

