/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.network.client;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.capabilities.polymorph.IPolymorphCapability;
import tamaized.aov.common.core.abilities.Aura;
import tamaized.aov.network.NetworkMessages;

public class ClientPacketHandlerAoVSimpleData
implements NetworkMessages.IMessage<ClientPacketHandlerAoVSimpleData> {
    private int id;
    private List<Aura> auras;
    private IPolymorphCapability.Morph polymorph;
    private byte renderBits;

    public ClientPacketHandlerAoVSimpleData(IAoVCapability cap, IPolymorphCapability poly, int entityID) {
        this.auras = cap.getAuras();
        this.polymorph = poly.getMorph();
        this.renderBits = poly.getFlagBits();
        this.id = entityID;
    }

    @Override
    public void handle(EntityPlayer player) {
        IPolymorphCapability poly;
        Entity entity = player.field_70170_p.func_73045_a(this.id);
        IAoVCapability cap = CapabilityList.getCap((ICapabilityProvider)entity, CapabilityList.AOV);
        if (cap != null) {
            cap.clearAuras();
            for (Aura aura : this.auras) {
                cap.addAura(aura);
            }
        }
        if ((poly = CapabilityList.getCap((ICapabilityProvider)entity, CapabilityList.POLYMORPH)) != null) {
            poly.morph(this.polymorph);
            poly.setFlagBits(this.renderBits);
        }
    }

    @Override
    public void toBytes(PacketBuffer packet) {
        packet.writeInt(this.id);
        packet.writeInt(this.auras.size());
        for (Aura aura : this.auras) {
            aura.encode((ByteBuf)packet);
        }
        packet.writeInt(this.polymorph == null ? -1 : this.polymorph.ordinal());
        packet.writeByte((int)this.renderBits);
    }

    @Override
    public ClientPacketHandlerAoVSimpleData fromBytes(PacketBuffer packet) {
        this.id = packet.readInt();
        this.auras = Lists.newArrayList();
        int size = packet.readInt();
        for (int index = 0; index < size; ++index) {
            this.auras.add(Aura.construct((ByteBuf)packet));
        }
        this.polymorph = IPolymorphCapability.Morph.getMorph(packet.readInt());
        this.renderBits = packet.readByte();
        return this;
    }
}

