/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.network.client;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.astro.IAstroCapability;
import tamaized.aov.network.NetworkMessages;

public class ClientPacketHandlerAstroAnimation
implements NetworkMessages.IMessage<ClientPacketHandlerAstroAnimation> {
    private int entityID;
    private IAstroCapability.IAnimation animation;

    public ClientPacketHandlerAstroAnimation(EntityLivingBase entity, IAstroCapability.IAnimation a) {
        IAstroCapability cap = CapabilityList.getCap((ICapabilityProvider)entity, CapabilityList.ASTRO, null);
        if (cap == null) {
            return;
        }
        this.entityID = entity.func_145782_y();
        this.animation = a;
    }

    @Override
    public void handle(EntityPlayer player) {
        Entity e = player.field_70170_p.func_73045_a(this.entityID);
        if (e instanceof EntityPlayer) {
            EntityPlayer p = (EntityPlayer)e;
            IAstroCapability cap = CapabilityList.getCap((ICapabilityProvider)player, CapabilityList.ASTRO);
            if (cap != null) {
                cap.playAnimation((EntityLivingBase)p, this.animation);
            }
        }
    }

    @Override
    public void toBytes(PacketBuffer packet) {
        packet.writeInt(this.entityID);
        packet.writeInt(IAstroCapability.IAnimation.getAnimationID(this.animation));
    }

    @Override
    public ClientPacketHandlerAstroAnimation fromBytes(PacketBuffer packet) {
        this.entityID = packet.readInt();
        this.animation = IAstroCapability.IAnimation.getAnimationFromID(packet.readInt());
        return this;
    }
}

