/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.network.client;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.Vec3d;
import tamaized.aov.common.helper.ParticleHelper;
import tamaized.aov.network.NetworkMessages;
import tamaized.aov.proxy.CommonProxy;

public class ClientPacketHandlerParticleMesh
implements NetworkMessages.IMessage<ClientPacketHandlerParticleMesh> {
    private static final ParticleHelper.MeshType[] MESH_TYPES = ParticleHelper.MeshType.values();
    private static final CommonProxy.ParticleType[] PARTICLE_TYPES = CommonProxy.ParticleType.values();
    private int mesh;
    private int particle;
    private Vec3d pos;
    private int range;
    private int color;

    public ClientPacketHandlerParticleMesh(ParticleHelper.MeshType mesh, CommonProxy.ParticleType particle, Vec3d pos, int range, int color) {
        this.mesh = mesh.ordinal();
        this.particle = particle.ordinal();
        this.pos = pos;
        this.range = range;
        this.color = color;
    }

    @Override
    public void handle(EntityPlayer player) {
        ParticleHelper.spawnParticleMesh(this.mesh >= 0 && this.mesh < MESH_TYPES.length ? MESH_TYPES[this.mesh] : ParticleHelper.MeshType.BURST, this.particle >= 0 && this.particle < PARTICLE_TYPES.length ? PARTICLE_TYPES[this.particle] : CommonProxy.ParticleType.Fluff, player.field_70170_p, this.pos, this.range, this.color);
    }

    @Override
    public void toBytes(PacketBuffer packet) {
        packet.writeInt(this.mesh);
        packet.writeInt(this.particle);
        packet.writeDouble(this.pos.field_72450_a);
        packet.writeDouble(this.pos.field_72448_b);
        packet.writeDouble(this.pos.field_72449_c);
        packet.writeInt(this.range);
        packet.writeInt(this.color);
    }

    @Override
    public ClientPacketHandlerParticleMesh fromBytes(PacketBuffer packet) {
        this.mesh = packet.readInt();
        this.particle = packet.readInt();
        this.pos = new Vec3d(packet.readDouble(), packet.readDouble(), packet.readDouble());
        this.range = packet.readInt();
        this.color = packet.readInt();
        return this;
    }
}

