/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.network.server;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.capabilities.polymorph.IPolymorphCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.core.skills.AoVSkill;
import tamaized.aov.common.core.skills.AoVSkills;
import tamaized.aov.network.NetworkMessages;

public class ServerPacketHandlerSpellSkill
implements NetworkMessages.IMessage<ServerPacketHandlerSpellSkill> {
    public PacketType id;
    public int[] data;
    public AbilityBase ability;

    public ServerPacketHandlerSpellSkill(PacketType type, @Nullable AbilityBase ability, int ... data) {
        this.id = type;
        this.data = data;
        this.ability = ability;
    }

    @Override
    public void handle(EntityPlayer player) {
        IAoVCapability cap = CapabilityList.getCap((ICapabilityProvider)player, CapabilityList.AOV);
        IPolymorphCapability poly = CapabilityList.getCap((ICapabilityProvider)player, CapabilityList.POLYMORPH);
        if (cap == null) {
            return;
        }
        switch (this.id) {
            case CAST_SPELL: {
                Entity e;
                Ability ability;
                if (this.data.length <= 0 || (ability = cap.getSlot(this.data[0])) == null) break;
                if (this.data.length > 1 && (e = player.field_70170_p.func_73045_a(this.data[1])) instanceof EntityLivingBase) {
                    ability.cast(player, (EntityLivingBase)e);
                    break;
                }
                ability.cast(player);
                break;
            }
            case SKILLEDIT_CHECK_CANOBTAIN: {
                AoVSkill skillToCheck;
                if (this.data.length <= 0 || (skillToCheck = AoVSkills.getSkillFromID(this.data[0])) == null || skillToCheck.getParent() != null && !cap.hasSkill(skillToCheck.getParent()) || cap.getSkillPoints() < skillToCheck.getCost() || cap.getLevel() < skillToCheck.getLevel() || cap.getSpentSkillPoints() < skillToCheck.getSpentPoints() || skillToCheck.isClassCore() && cap.hasCoreSkill() || skillToCheck.getParent() != null && !cap.hasSkill(skillToCheck.getParent())) break;
                cap.addObtainedSkill(skillToCheck);
                cap.setSkillPoints(cap.getSkillPoints() - skillToCheck.getCost());
                break;
            }
            case RESETSKILLS_FULL: {
                cap.reset(true);
                if (poly == null) break;
                poly.morph(null);
                break;
            }
            case RESETSKILLS_MINOR: {
                cap.reset(false);
                if (poly == null) break;
                poly.morph(null);
                break;
            }
            case SPELLBAR_REMOVE: {
                if (this.data.length <= 0) break;
                cap.removeSlot(this.data[0]);
                break;
            }
            case SPELLBAR_ADDNEAR: {
                cap.addToNearestSlot(this.ability);
                break;
            }
        }
    }

    @Override
    public void toBytes(PacketBuffer packet) {
        packet.writeInt(this.id.ordinal());
        packet.writeInt(this.data.length);
        for (int dat : this.data) {
            packet.writeInt(dat);
        }
        packet.writeInt(AbilityBase.getID(this.ability));
    }

    @Override
    public ServerPacketHandlerSpellSkill fromBytes(PacketBuffer packet) {
        PacketType[] types = PacketType.VALUES;
        int i = packet.readInt();
        this.id = i >= types.length ? null : types[i];
        int size = packet.readInt();
        this.data = new int[size];
        for (int index = 0; index < size; ++index) {
            this.data[index] = packet.readInt();
        }
        this.ability = AbilityBase.getAbilityFromID(packet.readInt());
        return this;
    }

    public static enum PacketType {
        SKILLEDIT_CHECK_CANOBTAIN,
        RESETSKILLS_FULL,
        RESETSKILLS_MINOR,
        SPELLBAR_REMOVE,
        SPELLBAR_ADDNEAR,
        CAST_SPELL;

        public static final PacketType[] VALUES;

        static {
            VALUES = PacketType.values();
        }
    }
}

