/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import tamaized.aov.common.capabilities.aov.AoVCapabilityHandler;
import tamaized.aov.common.capabilities.aov.AoVCapabilityStorage;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.capabilities.astro.AstroCapabilityHandler;
import tamaized.aov.common.capabilities.astro.AstroCapabilityStorage;
import tamaized.aov.common.capabilities.astro.IAstroCapability;
import tamaized.aov.common.capabilities.leap.ILeapCapability;
import tamaized.aov.common.capabilities.leap.LeapCapabilityHandler;
import tamaized.aov.common.capabilities.leap.LeapCapabilityStorage;
import tamaized.aov.common.capabilities.polymorph.IPolymorphCapability;
import tamaized.aov.common.capabilities.polymorph.PolymorphCapabilityHandler;
import tamaized.aov.common.capabilities.polymorph.PolymorphCapabilityStorage;
import tamaized.aov.common.capabilities.stun.IStunCapability;
import tamaized.aov.common.capabilities.stun.StunCapabilityHandler;
import tamaized.aov.common.capabilities.stun.StunCapabilityStorage;
import tamaized.aov.common.commands.AoVCommands;
import tamaized.aov.common.config.ClientConfig;
import tamaized.aov.common.config.CommonConfig;
import tamaized.aov.common.core.abilities.Abilities;
import tamaized.aov.common.core.skills.AoVSkills;
import tamaized.aov.network.NetworkMessages;
import tamaized.aov.registry.AoVAchievements;
import tamaized.aov.registry.AoVArmors;
import tamaized.aov.registry.AoVBlocks;
import tamaized.aov.registry.AoVDamageSource;
import tamaized.aov.registry.AoVEntities;
import tamaized.aov.registry.AoVItems;
import tamaized.aov.registry.AoVParticles;
import tamaized.aov.registry.AoVPotions;
import tamaized.aov.registry.AoVTabs;

@Mod(value="aov")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class AoV {
    public static final String MODID = "aov";
    public static final Logger LOGGER = LogManager.getLogger((String)"AoV");
    public static final IDataSerializer<Integer[]> VARINTS = new IDataSerializer<Integer[]>(){

        public void write(PacketBuffer buf, Integer[] values) {
            buf.func_150787_b(values.length);
            Integer[] integerArray = values;
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int value = integerArray[i];
                buf.func_150787_b(value);
            }
        }

        public Integer[] read(PacketBuffer buf) {
            int length = buf.func_150792_a();
            Integer[] values = new Integer[length];
            for (int i = 0; i < length; ++i) {
                values[i] = buf.func_150792_a();
            }
            return values;
        }

        @Nonnull
        public Integer[] copyValue(@Nonnull Integer[] value) {
            return value;
        }
    };
    public static CommonConfig config;
    public static ClientConfig config_client;
    public static SimpleChannel network;

    public AoV() {
        Pair specPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (ForgeConfigSpec)specPair.getRight());
        config = (CommonConfig)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (ForgeConfigSpec)specPair.getRight());
        config_client = (ClientConfig)specPair.getLeft();
        MinecraftForge.EVENT_BUS.addListener(this::serverStarting);
        IEventBus mod = FMLJavaModLoadingContext.get().getModEventBus();
        AoVTabs.register(mod);
        AoVItems.register(mod);
        AoVArmors.register(mod);
        AoVBlocks.register(mod);
        AoVPotions.register(mod);
        AoVAchievements.register(mod);
        AoVDamageSource.register(mod);
        AoVParticles.register(mod);
        AoVEntities.register(mod);
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        LOGGER.info("Initalizating AoV");
        CommonConfig.update();
        NetworkMessages.register(network);
        DataSerializers.func_187189_a(VARINTS);
        CapabilityManager.INSTANCE.register(IAoVCapability.class, (Capability.IStorage)new AoVCapabilityStorage(), AoVCapabilityHandler::new);
        CapabilityManager.INSTANCE.register(IAstroCapability.class, (Capability.IStorage)new AstroCapabilityStorage(), AstroCapabilityHandler::new);
        CapabilityManager.INSTANCE.register(IStunCapability.class, (Capability.IStorage)new StunCapabilityStorage(), StunCapabilityHandler::new);
        CapabilityManager.INSTANCE.register(ILeapCapability.class, (Capability.IStorage)new LeapCapabilityStorage(), LeapCapabilityHandler::new);
        CapabilityManager.INSTANCE.register(IPolymorphCapability.class, (Capability.IStorage)new PolymorphCapabilityStorage(), PolymorphCapabilityHandler::new);
        Abilities.register();
        AoVSkills.register();
    }

    public void serverStarting(FMLServerStartingEvent evt) {
        evt.getCommandDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)MODID).then(AoVCommands.Open.register())).then(AoVCommands.SetLevel.register())).then(AoVCommands.Reset.register())).then(AoVCommands.Debug.register()));
    }

    static {
        network = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(MODID, MODID)).clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).networkProtocolVersion(() -> "1").simpleChannel();
    }
}

