/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class RenderUtils {
    private static float zIndex = 0.0f;

    public static void setup(float zindex) {
        zIndex = zindex;
    }

    public static void renderRect(float x, float y, float w, float h) {
        RenderUtils.renderRect(x, y, w, h, true, -1);
    }

    public static void renderRect(float x, float y, float w, float h, boolean texture, int color) {
        if (texture) {
            RenderUtils.renderRect(x, y, w, h, 0.0f, 0.0f);
        } else {
            BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            RenderUtils.setupRectVerticies(buffer, x, y, w, h, 0.0f, 0.0f, 0.0f, 0.0f, false, color);
            GlStateManager.disableTexture();
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.enableTexture();
        }
    }

    public static void renderRect(float x, float y, float w, float h, float u, float v) {
        RenderUtils.renderRect(x, y, w, h, u, v, 1.0f, 1.0f);
    }

    public static void renderRect(float x, float y, float w, float h, float u, float v, float ue, float ve) {
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        RenderUtils.setupRectVerticies(buffer, x, y, w, h, u, v, ue, ve, true, -1);
        Tessellator.func_178181_a().func_78381_a();
    }

    public static BufferBuilder setupRectVerticies(BufferBuilder buffer, float x, float y, float w, float h, float u, float v, float ue, float ve, boolean texture, int color) {
        int r = color >> 24 & 0xFF;
        int g = color >> 16 & 0xFF;
        int b = color >> 8 & 0xFF;
        int a = color & 0xFF;
        buffer.func_181662_b((double)x, (double)(y + h), (double)zIndex);
        if (texture) {
            buffer.func_187315_a((double)u, (double)ve);
        }
        buffer.func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(x + w), (double)(y + h), (double)zIndex);
        if (texture) {
            buffer.func_187315_a((double)ue, (double)ve);
        }
        buffer.func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)(x + w), (double)y, (double)zIndex);
        if (texture) {
            buffer.func_187315_a((double)ue, (double)v);
        }
        buffer.func_181669_b(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, (double)zIndex);
        if (texture) {
            buffer.func_187315_a((double)u, (double)v);
        }
        buffer.func_181669_b(r, g, b, a).func_181675_d();
        return buffer;
    }
}

