/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Objects;
import net.minecraft.client.MainWindow;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.AoV;
import tamaized.aov.client.gui.AoVUIBar;
import tamaized.aov.client.gui.GuiScreenClose;
import tamaized.aov.client.gui.RenderUtils;
import tamaized.aov.client.gui.buttons.BlankButton;
import tamaized.aov.client.gui.buttons.SpellButton;
import tamaized.aov.common.blocks.BlockAngelicBlock;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.core.abilities.universal.InvokeMass;
import tamaized.aov.common.gui.GuiHandler;
import tamaized.aov.network.server.ServerPacketHandlerSpellSkill;

public class SpellBookGUI
extends GuiScreenClose {
    private final BlockAngelicBlock.ClassType parent;

    public SpellBookGUI(BlockAngelicBlock.ClassType parent) {
        super(SpellBookGUI.makeTranslationKey("spellbook"));
        this.parent = parent;
    }

    public void init() {
        int margin = 20;
        int padding = 100;
        float workW = this.width - padding;
        int loc1 = (int)((double)workW * 0.25) + margin;
        int loc2 = (int)((double)workW * 0.75) + margin;
        this.buttons.add(new Button(loc1, this.height - 25, 80, 20, I18n.func_135052_a((String)"aov.gui.button.back", (Object[])new Object[0]), button -> GuiHandler.openGui(GuiHandler.GUI.SKILLS, this.parent)));
        this.buttons.add(new Button(loc2, this.height - 25, 80, 20, I18n.func_135052_a((String)"aov.gui.button.close", (Object[])new Object[0]), button -> Objects.requireNonNull(this.minecraft).field_71439_g.func_71053_j()));
        int xLoc = 50;
        int yLoc = 50;
        int y = this.height - 47;
        int x = this.width / 2;
        this.buttons.add(new BlankButton(x - 88, y, 16, 16, button -> this.sendPacketTypeRemoveSlot(0)));
        this.buttons.add(new BlankButton(x - 68, y, 16, 16, button -> this.sendPacketTypeRemoveSlot(1)));
        this.buttons.add(new BlankButton(x - 48, y, 16, 16, button -> this.sendPacketTypeRemoveSlot(2)));
        this.buttons.add(new BlankButton(x - 28, y, 16, 16, button -> this.sendPacketTypeRemoveSlot(3)));
        this.buttons.add(new BlankButton(x - 8, y, 16, 16, button -> this.sendPacketTypeRemoveSlot(4)));
        this.buttons.add(new BlankButton(x + 12, y, 16, 16, button -> this.sendPacketTypeRemoveSlot(5)));
        this.buttons.add(new BlankButton(x + 32, y, 16, 16, button -> this.sendPacketTypeRemoveSlot(6)));
        this.buttons.add(new BlankButton(x + 52, y, 16, 16, button -> this.sendPacketTypeRemoveSlot(7)));
        this.buttons.add(new BlankButton(x + 72, y, 16, 16, button -> this.sendPacketTypeRemoveSlot(8)));
        if (this.minecraft == null || this.minecraft.field_71439_g == null) {
            return;
        }
        IAoVCapability cap = CapabilityList.getCap((ICapabilityProvider)this.minecraft.field_71439_g, CapabilityList.AOV);
        if (cap == null) {
            return;
        }
        int index = 0;
        for (Ability ability : cap.getAbilities()) {
            this.buttons.add(new SpellButton(xLoc + 100 * (int)Math.floor(index / 6), yLoc + 25 * (index % 6), ability.getAbility(), button -> this.sendPacketTypeAddNearestSlot(((SpellButton)button).getSpell())));
            ++index;
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void tick() {
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.drawCenteredString(Objects.requireNonNull(this.minecraft).field_71466_p, I18n.func_135052_a((String)"aov.gui.title.spellbook", (Object[])new Object[0]), this.width / 2, 15, 0xFFFFFF);
        super.render(mouseX, mouseY, partialTicks);
        this.renderBar();
        for (Widget b : this.buttons) {
            SpellButton sb;
            if (!b.isMouseOver((double)mouseX, (double)mouseY) || !(b instanceof SpellButton) || (sb = (SpellButton)b).getSpell() == null || sb.getSpell().getDescriptionAsTextComponent() == null) continue;
            this.renderComponentHoverEffect(sb.getSpell().getDescriptionAsTextComponent(), mouseX, mouseY);
        }
    }

    private void renderBar() {
        if (this.minecraft == null) {
            return;
        }
        IAoVCapability cap = CapabilityList.getCap((ICapabilityProvider)this.minecraft.field_71439_g, CapabilityList.AOV);
        MainWindow sr = this.minecraft.field_195558_d;
        float alpha = 1.0f;
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        this.minecraft.func_110434_K().func_110577_a(AoVUIBar.widgetsTexPath);
        int i = sr.func_198107_o() / 2;
        RenderUtils.setup(this.blitOffset);
        RenderUtils.renderRect(i - 91, sr.func_198087_p() - 50, 182.0f, 22.0f, 0.0f, 0.0f, 0.7109375f, 0.0859375f);
        GlStateManager.enableRescaleNormal();
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderHelper.func_74520_c();
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)0.01f, (double)0.0, (double)0.0);
        GlStateManager.translated((double)-20.01f, (double)0.0, (double)0.0);
        for (int j = 0; j < 9; ++j) {
            GlStateManager.translated((double)20.01f, (double)0.0, (double)0.0);
            if (cap == null || cap.getSlot(j) == null) continue;
            int k = sr.func_198107_o() / 2 - 90 + 2;
            int l = sr.func_198087_p() - 47;
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            AoVUIBar.renderHotbarIcon(null, j, k, l, cap.getSlot(j).getAbility().getIcon(), cap.getSlot(j).getAbility() instanceof InvokeMass && cap.getInvokeMass());
        }
        GlStateManager.popMatrix();
        RenderHelper.func_74518_a();
        GlStateManager.disableRescaleNormal();
        GlStateManager.disableBlend();
    }

    private void sendPacketTypeRemoveSlot(int slot) {
        AoV.network.sendToServer((Object)new ServerPacketHandlerSpellSkill(ServerPacketHandlerSpellSkill.PacketType.SPELLBAR_REMOVE, null, slot));
    }

    private void sendPacketTypeAddNearestSlot(AbilityBase ability) {
        AoV.network.sendToServer((Object)new ServerPacketHandlerSpellSkill(ServerPacketHandlerSpellSkill.PacketType.SPELLBAR_ADDNEAR, ability, 0));
    }
}

