/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.client.gui.buttons;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import tamaized.aov.client.gui.AoVSkillsGUI;
import tamaized.aov.client.gui.AoVUIBar;
import tamaized.aov.client.gui.RenderUtils;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.skills.AoVSkill;

public class SkillButton
extends Button {
    private final AoVSkill skill;
    private boolean isObtained;
    private boolean notEnoughPoints = false;

    public SkillButton(int x, int y, AoVSkill s) {
        super(x, y, 18, 18, "", p_onPress_1_ -> {});
        this.skill = s;
        this.update(null);
    }

    public void onClick(double mouseX, double mouseY) {
        super.onClick(mouseX, mouseY);
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen instanceof AoVSkillsGUI) {
            ((AoVSkillsGUI)screen).doSkillButton(this);
        }
    }

    public AoVSkill getSkill() {
        return this.skill;
    }

    public boolean isObtained() {
        return this.isObtained;
    }

    public boolean hasEnoughPoints() {
        return !this.notEnoughPoints;
    }

    public void update(IAoVCapability cap) {
        this.active = false;
        this.notEnoughPoints = true;
        if (cap == null) {
            return;
        }
        if (!(cap.hasCoreSkill() && this.skill.isClassCore() || this.skill.getParent() != null && !cap.hasSkill(this.skill.getParent()))) {
            this.doChecks(cap);
        }
        if (cap.hasSkill(this.skill)) {
            this.active = false;
            this.isObtained = true;
        } else {
            this.isObtained = false;
        }
    }

    private void doChecks(IAoVCapability cap) {
        if (cap == null) {
            return;
        }
        if (this.canObtain(cap)) {
            this.notEnoughPoints = false;
            this.active = true;
        }
    }

    public boolean canObtain(IAoVCapability cap) {
        return cap != null && cap.getSkillPoints() >= this.skill.getCost() && cap.getLevel() >= this.skill.getLevel() && cap.getSpentSkillPoints() >= this.skill.getSpentPoints();
    }

    public void render(int mouseX, int mouseY, float p_191745_4_) {
        if (this.visible) {
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
            GlStateManager.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
            GlStateManager.blendFunc((int)770, (int)771);
            this.mouseDragged(mouseX, mouseY, 0, mouseX, mouseY);
            GlStateManager.enableBlend();
            int j = -69;
            if (this.packedFGColor != 0) {
                j = this.packedFGColor;
            } else if (!this.active) {
                j = -2004317953;
            } else if (this.isHovered) {
                j = -1;
            }
            if (this.notEnoughPoints) {
                j = -16777046;
            }
            if (this.isObtained) {
                j = 0xFF00FF;
            }
            RenderUtils.setup(this.blitOffset);
            RenderUtils.renderRect((float)this.x, (float)this.y, (float)this.width, (float)this.height, false, j);
            float alpha = (float)(j & 0xFF) / 255.0f;
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            AoVUIBar.renderHotbarIcon(null, 0, this.x + 1, this.y + 1, this.skill == null ? null : this.skill.getIcon(), false);
        }
    }
}

