/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.blocks;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import tamaized.aov.common.gui.GuiHandler;

public class BlockAngelicBlock
extends Block {
    public static final EnumProperty<Direction.Axis> AXIS = EnumProperty.func_177706_a((String)"axis", Direction.Axis.class, (Enum[])new Direction.Axis[]{Direction.Axis.X, Direction.Axis.Z});
    private final ClassType type;

    public BlockAngelicBlock(ClassType type, Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(AXIS, (Comparable)Direction.Axis.X));
        this.type = type;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{AXIS});
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Deprecated
    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (this.type == ClassType.ALL && !player.func_184812_l_() || !(player instanceof ServerPlayerEntity)) {
            return this.type != ClassType.ALL || player.func_184812_l_();
        }
        GuiHandler.openGui(GuiHandler.GUI.SKILLS, this.type, (ServerPlayerEntity)player);
        return true;
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation direction) {
        switch (direction) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.func_177229_b(AXIS)) {
                    case X: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.Z);
                    }
                    case Z: {
                        return (BlockState)state.func_206870_a(AXIS, (Comparable)Direction.Axis.X);
                    }
                }
                return state;
            }
        }
        return state;
    }

    public static enum ClassType {
        ALL,
        FAVOREDSOUL,
        CLERIC,
        PALADIN,
        ASTRO,
        DRUID;

        public static final ClassType[] values;

        static {
            values = ClassType.values();
        }
    }
}

