/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.capabilities;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import tamaized.aov.common.capabilities.IPlayerCapabilityHandler;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.capabilities.astro.IAstroCapability;
import tamaized.aov.common.capabilities.leap.ILeapCapability;
import tamaized.aov.common.capabilities.polymorph.IPolymorphCapability;
import tamaized.aov.common.capabilities.stun.IStunCapability;

@Mod.EventBusSubscriber(modid="aov")
public class CapabilityList {
    @CapabilityInject(value=IAoVCapability.class)
    public static final Capability<IAoVCapability> AOV = (Capability)CapabilityList.getNull();
    @CapabilityInject(value=IAstroCapability.class)
    public static final Capability<IAstroCapability> ASTRO = (Capability)CapabilityList.getNull();
    @CapabilityInject(value=IStunCapability.class)
    public static final Capability<IStunCapability> STUN = (Capability)CapabilityList.getNull();
    @CapabilityInject(value=ILeapCapability.class)
    public static final Capability<ILeapCapability> LEAP = (Capability)CapabilityList.getNull();
    @CapabilityInject(value=IPolymorphCapability.class)
    public static final Capability<IPolymorphCapability> POLYMORPH = (Capability)CapabilityList.getNull();

    public static <T> T getCap(@Nullable ICapabilityProvider provider, Capability<T> cap) {
        return CapabilityList.getCap(provider, cap, null);
    }

    public static <T> T getCap(@Nullable ICapabilityProvider provider, Capability<T> cap, @Nullable Direction face) {
        LazyOptional data = provider != null ? provider.getCapability(cap, face) : null;
        return (T)(data != null && data.isPresent() ? data.orElseThrow(IllegalStateException::new) : null);
    }

    @SubscribeEvent
    public static void attachCapabilityEntity(AttachCapabilitiesEvent<Entity> e) {
        if (e.getObject() instanceof PlayerEntity) {
            e.addCapability(IAoVCapability.ID, (ICapabilityProvider)new ICapabilitySerializable<CompoundNBT>(){
                IAoVCapability inst = (IAoVCapability)AOV.getDefaultInstance();

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
                    return AOV.orEmpty(capability, LazyOptional.of(() -> this.inst)).cast();
                }

                public CompoundNBT serializeNBT() {
                    return (CompoundNBT)AOV.getStorage().writeNBT(AOV, (Object)this.inst, null);
                }

                public void deserializeNBT(CompoundNBT nbt) {
                    AOV.getStorage().readNBT(AOV, (Object)this.inst, null, (INBT)nbt);
                }
            });
            e.addCapability(IAstroCapability.ID, (ICapabilityProvider)new ICapabilitySerializable<CompoundNBT>(){
                IAstroCapability inst = (IAstroCapability)ASTRO.getDefaultInstance();

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
                    return ASTRO.orEmpty(capability, LazyOptional.of(() -> this.inst)).cast();
                }

                public CompoundNBT serializeNBT() {
                    return (CompoundNBT)ASTRO.getStorage().writeNBT(ASTRO, (Object)this.inst, null);
                }

                public void deserializeNBT(CompoundNBT nbt) {
                    ASTRO.getStorage().readNBT(ASTRO, (Object)this.inst, null, (INBT)nbt);
                }
            });
            e.addCapability(IPolymorphCapability.ID, (ICapabilityProvider)new ICapabilitySerializable<CompoundNBT>(){
                IPolymorphCapability inst = (IPolymorphCapability)POLYMORPH.getDefaultInstance();

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
                    return POLYMORPH.orEmpty(capability, LazyOptional.of(() -> this.inst)).cast();
                }

                public CompoundNBT serializeNBT() {
                    return (CompoundNBT)POLYMORPH.getStorage().writeNBT(POLYMORPH, (Object)this.inst, null);
                }

                public void deserializeNBT(CompoundNBT nbt) {
                    POLYMORPH.getStorage().readNBT(POLYMORPH, (Object)this.inst, null, (INBT)nbt);
                }
            });
        }
        if (e.getObject() instanceof LivingEntity) {
            e.addCapability(IStunCapability.ID, (ICapabilityProvider)new ICapabilitySerializable<CompoundNBT>(){
                IStunCapability inst = (IStunCapability)STUN.getDefaultInstance();

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
                    return STUN.orEmpty(capability, LazyOptional.of(() -> this.inst)).cast();
                }

                public CompoundNBT serializeNBT() {
                    return (CompoundNBT)STUN.getStorage().writeNBT(STUN, (Object)this.inst, null);
                }

                public void deserializeNBT(CompoundNBT nbt) {
                    STUN.getStorage().readNBT(STUN, (Object)this.inst, null, (INBT)nbt);
                }
            });
            e.addCapability(ILeapCapability.ID, (ICapabilityProvider)new ICapabilitySerializable<CompoundNBT>(){
                ILeapCapability inst = (ILeapCapability)LEAP.getDefaultInstance();

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
                    return LEAP.orEmpty(capability, LazyOptional.of(() -> this.inst)).cast();
                }

                public CompoundNBT serializeNBT() {
                    return (CompoundNBT)LEAP.getStorage().writeNBT(LEAP, (Object)this.inst, null);
                }

                public void deserializeNBT(CompoundNBT nbt) {
                    LEAP.getStorage().readNBT(LEAP, (Object)this.inst, null, (INBT)nbt);
                }
            });
        }
    }

    @SubscribeEvent
    public static void updateClone(PlayerEvent.Clone event) {
        CapabilityList.handlePlayerCopy(event.getPlayer(), event.getOriginal(), AOV);
        CapabilityList.handlePlayerCopy(event.getPlayer(), event.getOriginal(), POLYMORPH);
    }

    public static <C extends IPlayerCapabilityHandler<C>> void handlePlayerCopy(PlayerEntity player, PlayerEntity old, Capability<C> cap) {
        IPlayerCapabilityHandler newCap = (IPlayerCapabilityHandler)CapabilityList.getCap((ICapabilityProvider)player, cap);
        IPlayerCapabilityHandler oldCap = (IPlayerCapabilityHandler)CapabilityList.getCap((ICapabilityProvider)old, cap);
        if (newCap != null && oldCap != null) {
            newCap.handleClone(oldCap);
        }
    }

    @SubscribeEvent
    public static void onJoin(EntityJoinWorldEvent e) {
        IAstroCapability astro;
        IAoVCapability cap = CapabilityList.getCap((ICapabilityProvider)e.getEntity(), AOV);
        if (cap != null) {
            cap.markDirty();
            cap.setLoaded();
        }
        if ((astro = CapabilityList.getCap((ICapabilityProvider)e.getEntity(), ASTRO)) != null) {
            astro.markDirty();
        }
    }

    @Nonnull
    private static <T> T getNull() {
        return null;
    }
}

