/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.capabilities.leap;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraftforge.fml.network.PacketDistributor;
import tamaized.aov.AoV;
import tamaized.aov.common.capabilities.leap.ILeapCapability;
import tamaized.aov.network.client.ClientPacketHandlerLeap;

public class LeapCapabilityHandler
implements ILeapCapability {
    private boolean dirty = false;
    private int tick;
    private int leapDuration;
    private int maxLeapDuration = 300;

    @Override
    public void update(LivingEntity entity) {
        --this.leapDuration;
        if (this.dirty || ++this.tick % 20 == 0) {
            this.sendPacketUpdates((Entity)entity);
        }
    }

    @Override
    public int getLeapDuration() {
        return this.leapDuration;
    }

    @Override
    public void setLeapDuration(int duration) {
        this.maxLeapDuration = this.leapDuration <= 0 || this.maxLeapDuration <= this.leapDuration ? duration : this.maxLeapDuration;
        this.leapDuration = duration;
        this.dirty = true;
    }

    @Override
    public int getMaxLeapDuration() {
        return this.maxLeapDuration;
    }

    private void sendPacketUpdates(Entity e) {
        if (!e.field_70170_p.field_72995_K) {
            AoV.network.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> e), (Object)new ClientPacketHandlerLeap(e, this));
        }
    }
}

