/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.config;

import com.electronwill.nightconfig.core.utils.ConfigWrapper;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.AirItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import tamaized.aov.AoV;

@Mod.EventBusSubscriber(modid="aov")
public class CommonConfig {
    public static Set<Item> CENTERED_WEAR = ImmutableSet.of();
    public ConfigWrapper file;
    public Earthquake EARTHQUAKE = new Earthquake();
    public ForgeConfigSpec.IntValue maxlevel;
    public ForgeConfigSpec.ConfigValue<Integer> recharge;
    public ForgeConfigSpec.BooleanValue experience;
    public ForgeConfigSpec.BooleanValue handwrapsSpeed;
    public ForgeConfigSpec.ConfigValue<List<? extends String>> centered;
    public static boolean LOADED = false;

    public CommonConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Manages the Earthquake Spell Block Destruction").push("Earthquake");
        this.EARTHQUAKE.enable = builder.translation("Enable").comment("Enable Earthquake Destruction").define("enable", true);
        this.EARTHQUAKE.air = builder.translation("Enable Air").comment("If Disabled, destruction stops at the last block rather than setting to air").define("air", true);
        this.EARTHQUAKE.ticks = builder.translation("Destruction Ticks").comment("Amount of Ticks to wait until the next Destruction; Lower = Sooner").defineInRange("ticks", 5, 1, Integer.MAX_VALUE);
        this.EARTHQUAKE.chance = builder.translation("Destruction Chance").comment("Chance that a Destruction will take place; Lower = Higher Chance").defineInRange("chance", 5, 1, Integer.MAX_VALUE);
        this.EARTHQUAKE.destruction = builder.translation("Destruction Order").comment("domain:name|other\n[domain] defaults to `minecraft`\n[other] is what CAN be broken down but won't be broken down into.\n\nExample: [minecraft:gravel|minecraft:grass] may have Cobble before it, so Cobble breaks down into Gravel, which may have Dirt after it so Gravel breaks down into Dirt.\nGrass will also break down into Dirt but Cobble will never break down into Grass.").define("destruction", (Object)Lists.newArrayList((Object[])new String[]{CommonConfig.getRegName(Blocks.field_150348_b), CommonConfig.getRegName(Blocks.field_150347_e), CommonConfig.getRegName(Blocks.field_150351_n) + "|" + CommonConfig.getRegName(Blocks.field_196658_i) + "|" + CommonConfig.getRegName(Blocks.field_185774_da) + "|" + CommonConfig.getRegName(Blocks.field_196660_k), CommonConfig.getRegName(Blocks.field_150346_d) + "|" + CommonConfig.getRegName(Blocks.field_150322_A), CommonConfig.getRegName(Blocks.field_150354_m) + "|" + CommonConfig.getRegName(Blocks.field_196611_F)}), o -> o instanceof String);
        builder.pop();
        this.maxlevel = builder.translation("Max Level").comment("Sets the maximum level").defineInRange("maxLevel", 15, 1, Integer.MAX_VALUE);
        this.recharge = builder.translation("Recharge Delay").comment("Sets the rate, in ticks, at which all abilities will replenish a single charge. -1 disables this").define("recharge", (Object)-1);
        this.experience = builder.translation("Enable Vanilla Experience gain").comment("Determines whether or not vanilla experience contributes to AoV experience gain").define("experience", false);
        this.handwrapsSpeed = builder.translation("Speedy Handwraps").comment("Handwraps add +6 to base attack speed").define("handwrapsSpeed", true);
        this.centered = builder.translation("Centered Wear").comment("domain:name\ndomain defaults to `minecraft`").defineList("centered", (List)Lists.newArrayList((Object[])new String[]{"aov:handwraps", CommonConfig.getRegName(Items.field_151041_m), CommonConfig.getRegName(Items.field_151053_p), CommonConfig.getRegName(Items.field_151017_I), CommonConfig.getRegName(Items.field_151039_o), CommonConfig.getRegName(Items.field_151038_n), CommonConfig.getRegName(Items.field_151021_T), CommonConfig.getRegName(Items.field_151027_R), CommonConfig.getRegName(Items.field_151024_Q), CommonConfig.getRegName(Items.field_151026_S)}), o -> o instanceof String);
    }

    private static String getRegName(Item item) {
        return Objects.requireNonNull(item.getRegistryName()).func_110623_a();
    }

    private static String getRegName(Block block) {
        return Objects.requireNonNull(block.getRegistryName()).func_110623_a();
    }

    private static void setupCenteredWear() {
        ArrayList list = Lists.newArrayList();
        for (String next : (List)AoV.config.centered.get()) {
            Item item;
            String[] split = next.split(":");
            String domain = "minecraft";
            String regname = split[0];
            if (split.length > 1) {
                domain = split[0];
                regname = split[1];
            }
            if ((item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(domain, regname))) == null || item instanceof AirItem) continue;
            list.add(item);
        }
        CENTERED_WEAR = ImmutableSet.copyOf((Collection)list);
    }

    public static void update() {
        CommonConfig.setupCenteredWear();
        LOADED = true;
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("aov")) {
            CommonConfig.update();
        }
    }

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading event) {
        if (event.getConfig().getModId().equals("aov")) {
            AoV.config.file = (ConfigWrapper)event.getConfig().getConfigData();
            CommonConfig.update();
        }
    }

    @SubscribeEvent
    public static void onFileChange(ModConfig.ConfigReloading event) {
        if (event.getConfig().getModId().equals("aov")) {
            CommonConfig.update();
        }
    }

    public static class Earthquake {
        public ForgeConfigSpec.BooleanValue enable;
        public ForgeConfigSpec.BooleanValue air;
        public ForgeConfigSpec.IntValue ticks;
        public ForgeConfigSpec.IntValue chance;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> destruction;
    }
}

