/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.capabilities.polymorph.IPolymorphCapability;
import tamaized.aov.common.core.abilities.Ability;

public abstract class AbilityBase {
    private static final List<AbilityBase> registry = Lists.newArrayList();
    private final List<TranslationTextComponent> description = Lists.newArrayList();
    private ITextComponent descriptionCache;

    public AbilityBase(TranslationTextComponent ... desc) {
        for (TranslationTextComponent component : desc) {
            this.description.add(component);
            this.description.add(new TranslationTextComponent("\n", new Object[0]));
        }
        registry.add(this);
    }

    public static int getID(AbilityBase skill) {
        return registry.contains(skill) ? registry.indexOf(skill) : -1;
    }

    public static AbilityBase getAbilityFromID(int id) {
        return id >= 0 && id < registry.size() ? registry.get(id) : null;
    }

    public final int getID() {
        return AbilityBase.getID(this);
    }

    public boolean shouldDisable(@Nullable PlayerEntity caster, IAoVCapability cap) {
        IPolymorphCapability poly = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.POLYMORPH);
        return poly != null && poly.getMorph() == IPolymorphCapability.Morph.Wolf;
    }

    public boolean runOnClient() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public final List<String> getDescription() {
        ArrayList list = Lists.newArrayList();
        for (TranslationTextComponent s : this.description) {
            Object[] args = new Object[s.func_150271_j().length];
            for (int index = 0; index < s.func_150271_j().length; ++index) {
                args[index] = I18n.func_135052_a((String)s.func_150271_j()[index].toString(), (Object[])new Object[0]);
            }
            list.add(I18n.func_135052_a((String)s.func_150268_i(), (Object[])args));
        }
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    public final ITextComponent getDescriptionAsTextComponent() {
        if (this.descriptionCache == null && !this.description.isEmpty()) {
            TranslationTextComponent component = new TranslationTextComponent(this.description.get(0).func_150268_i(), this.description.get(0).func_150271_j());
            for (int i = 1; i < this.description.size(); ++i) {
                component.func_150257_a((ITextComponent)new TranslationTextComponent(this.description.get(i).func_150268_i(), this.description.get(i).func_150271_j()));
            }
            this.descriptionCache = component.func_150255_a(new Style().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)component)));
        }
        return this.descriptionCache;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract String getName();

    public abstract int getMaxCharges();

    public int getExtraCharges(LivingEntity entity, IAoVCapability cap) {
        return 0;
    }

    public abstract int getChargeCost();

    public abstract double getMaxDistance();

    public abstract int getCoolDown();

    public abstract boolean usesInvoke();

    public abstract boolean isCastOnTarget(PlayerEntity var1, IAoVCapability var2, LivingEntity var3);

    public int getCost(IAoVCapability cap) {
        return this.usesInvoke() && cap.getInvokeMass() ? this.getChargeCost() * 2 : this.getChargeCost();
    }

    public boolean canUseOnCooldown(IAoVCapability cap, PlayerEntity caster) {
        return false;
    }

    public void onCooldownCast(Ability ability, PlayerEntity caster, LivingEntity target, int cooldown) {
    }

    public abstract boolean cast(Ability var1, PlayerEntity var2, LivingEntity var3);

    public abstract ResourceLocation getIcon();

    static final class NullAbility
    extends AbilityBase {
        private final String name;

        public NullAbility(String name) {
            super(new TranslationTextComponent[0]);
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getMaxCharges() {
            return 0;
        }

        @Override
        public int getChargeCost() {
            return 0;
        }

        @Override
        public double getMaxDistance() {
            return 0.0;
        }

        @Override
        public int getCoolDown() {
            return 0;
        }

        @Override
        public boolean usesInvoke() {
            return false;
        }

        @Override
        public boolean isCastOnTarget(PlayerEntity caster, IAoVCapability cap, LivingEntity target) {
            return false;
        }

        @Override
        public boolean cast(Ability ability, PlayerEntity caster, LivingEntity target) {
            return false;
        }

        @Override
        public ResourceLocation getIcon() {
            return null;
        }
    }
}

