/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.astro;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.capabilities.astro.IAstroCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.entity.EntitySpellVanillaParticles;
import tamaized.aov.registry.AoVPotions;

public class Draw
extends AbilityBase {
    private static final ResourceLocation icon = new ResourceLocation("aov", "textures/spells/draw.png");
    private static final int charges = -1;
    private static final int distance = 10;

    public Draw() {
        super(new TranslationTextComponent(Draw.getStaticName(), new Object[0]), new TranslationTextComponent("", new Object[0]), new TranslationTextComponent("aov.spells.global.range", new Object[]{10}), new TranslationTextComponent("", new Object[0]), new TranslationTextComponent("aov.spells.draw.desc", new Object[0]));
    }

    public static String getStaticName() {
        return "aov.spells.draw.name";
    }

    public static void doDrawEffects(LivingEntity caster, @Nonnull IAstroCapability.ICard card, int potency, @Nullable IAstroCapability.ICard burn, boolean fromAoe) {
        int ticks = 300;
        int hardcodedBalancePotency = fromAoe ? potency : 0;
        boolean aoe = false;
        if (burn != null) {
            switch (burn) {
                default: {
                    hardcodedBalancePotency = 2;
                    potency = (int)((float)potency * 2.5f);
                    if (potency > 0) break;
                    potency = 2;
                    break;
                }
                case Spear: 
                case Arrow: {
                    ticks *= 3;
                    break;
                }
                case Ewer: 
                case Spire: {
                    aoe = true;
                    hardcodedBalancePotency = 1;
                    potency = (int)((float)potency * 1.5f);
                    if (potency > 0) break;
                    potency = 1;
                }
            }
        }
        if (aoe) {
            IAoVCapability cap = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.AOV);
            int range = 16;
            for (LivingEntity e : caster.field_70170_p.func_217357_a(LivingEntity.class, new AxisAlignedBB(caster.field_70165_t - (double)range, caster.field_70163_u - (double)range, caster.field_70161_v - (double)range, caster.field_70165_t + (double)range, caster.field_70163_u + (double)range, caster.field_70161_v + (double)range))) {
                if (cap != null && !IAoVCapability.canBenefit((Entity)caster, cap, e)) continue;
                Draw.doDrawEffects(e, card, potency, null, true);
            }
            return;
        }
        switch (card) {
            default: {
                caster.func_195064_c(new EffectInstance((Effect)Objects.requireNonNull(AoVPotions.balance.get()), ticks, hardcodedBalancePotency));
                break;
            }
            case Bole: {
                caster.func_195064_c(new EffectInstance(Effects.field_76429_m, ticks, potency));
                caster.func_195064_c(new EffectInstance(Effects.field_180152_w, ticks, (int)Math.floor((float)potency / 2.0f)));
                caster.func_195064_c(new EffectInstance(Effects.field_76443_y, 60, (int)Math.floor((float)potency / 2.0f)));
                break;
            }
            case Spear: {
                caster.func_195064_c(new EffectInstance((Effect)Objects.requireNonNull(AoVPotions.spear.get()), ticks, potency));
                break;
            }
            case Arrow: {
                caster.func_195064_c(new EffectInstance(Effects.field_76422_e, ticks, potency));
                break;
            }
            case Ewer: {
                caster.func_195064_c(new EffectInstance((Effect)Objects.requireNonNull(AoVPotions.ewer.get()), ticks, 0));
                break;
            }
            case Spire: {
                caster.func_195064_c(new EffectInstance((Effect)Objects.requireNonNull(AoVPotions.spire.get()), ticks, potency));
            }
        }
        caster.field_70170_p.func_217376_c((Entity)new EntitySpellVanillaParticles(caster.field_70170_p, (Entity)caster, (IParticleData)ParticleTypes.field_197622_o, 5));
    }

    @Override
    public ResourceLocation getIcon() {
        return icon;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)Draw.getStaticName(), (Object[])new Object[0]);
    }

    @Override
    public int getCoolDown() {
        return 30;
    }

    @Override
    public int getMaxCharges() {
        return -1;
    }

    @Override
    public int getChargeCost() {
        return 0;
    }

    @Override
    public double getMaxDistance() {
        return 10.0;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean isCastOnTarget(PlayerEntity caster, IAoVCapability cap, LivingEntity target) {
        return IAoVCapability.canBenefit((Entity)caster, cap, target);
    }

    @Override
    public boolean cast(Ability ability, PlayerEntity caster, LivingEntity target) {
        IAstroCapability astro = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.ASTRO);
        IAoVCapability aov = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.AOV);
        if (astro == null || aov == null) {
            return false;
        }
        if (astro.getDraw() == null) {
            astro.drawCard((LivingEntity)caster);
            ability.setNextCooldown(1);
            ability.setTimer(30);
        } else {
            IAstroCapability.ICard card = astro.getDraw();
            PlayerEntity entity = target == null || (double)caster.func_70032_d((Entity)target) >= this.getMaxDistance() ? caster : target;
            int potency = (int)Math.floor(aov.getSpellPower() / 10.0f);
            IAstroCapability.ICard burn = astro.getBurn();
            astro.useDraw((LivingEntity)caster);
            Draw.doDrawEffects((LivingEntity)entity, card, potency, burn, false);
            aov.addExp((Entity)caster, 15, this);
            ability.setTimer(-1);
        }
        astro.sendPacketUpdates(caster);
        return true;
    }
}

