/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.astro;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.entity.EntitySpellVanillaParticles;
import tamaized.aov.registry.SoundEvents;

public class TimeDilation
extends AbilityBase {
    private static final ResourceLocation icon = new ResourceLocation("aov", "textures/spells/timedilation.png");
    private static final int charges = -1;
    private static final int distance = 10;

    public TimeDilation() {
        super(new TranslationTextComponent(TimeDilation.getStaticName(), new Object[0]), new TranslationTextComponent("", new Object[0]), new TranslationTextComponent("aov.spells.global.range", new Object[]{10}), new TranslationTextComponent("", new Object[0]), new TranslationTextComponent("aov.spells.timedilation.desc", new Object[0]));
    }

    public static String getStaticName() {
        return "aov.spells.timedilation.name";
    }

    @Override
    public ResourceLocation getIcon() {
        return icon;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)TimeDilation.getStaticName(), (Object[])new Object[0]);
    }

    @Override
    public int getCoolDown() {
        return 90;
    }

    @Override
    public int getMaxCharges() {
        return -1;
    }

    @Override
    public int getChargeCost() {
        return 0;
    }

    @Override
    public double getMaxDistance() {
        return 10.0;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean isCastOnTarget(PlayerEntity caster, IAoVCapability cap, LivingEntity target) {
        return IAoVCapability.canBenefit((Entity)caster, cap, target);
    }

    @Override
    public boolean cast(Ability ability, PlayerEntity caster, LivingEntity target) {
        IAoVCapability aov = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.AOV);
        PlayerEntity entity = target != null && aov != null && IAoVCapability.canBenefit((Entity)caster, aov, target) ? target : caster;
        for (EffectInstance effect : entity.func_70651_bq()) {
            if (effect.func_188419_a().func_220303_e() == EffectType.HARMFUL) continue;
            entity.func_195064_c(new EffectInstance(effect.func_188419_a(), effect.func_76459_b() * 2, effect.func_76458_c(), effect.func_82720_e(), effect.func_188418_e()));
        }
        if (!entity.field_70170_p.field_72995_K) {
            SoundEvents.playMovingSoundOnServer(SoundEvents.timedilation, (Entity)entity);
            entity.field_70170_p.func_217376_c((Entity)new EntitySpellVanillaParticles(entity.field_70170_p, (Entity)entity, (IParticleData)ParticleTypes.field_197632_y, 3));
            if (aov != null) {
                aov.addExp((Entity)caster, 20, ability.getAbility());
            }
        }
        return true;
    }
}

