/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.druid;

import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.capabilities.polymorph.IPolymorphCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;

public class FormPack
extends AbilityBase {
    private static final String UNLOC = "aov.spells.formpack";
    private static final float DAMAGE = 4.0f;
    private static final int CHARGES = 2;
    private static final ResourceLocation ICON = new ResourceLocation("aov", "textures/spells/formpack.png");

    public FormPack() {
        super(new TranslationTextComponent(UNLOC.concat(".name"), new Object[0]), new TranslationTextComponent("", new Object[0]), new TranslationTextComponent("aov.spells.global.charges", new Object[]{2}), new TranslationTextComponent("aov.spells.global.damage", new Object[]{Float.valueOf(4.0f)}), new TranslationTextComponent("", new Object[0]), new TranslationTextComponent(UNLOC.concat(".desc"), new Object[0]));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)UNLOC.concat(".name"), (Object[])new Object[0]);
    }

    @Override
    public int getMaxCharges() {
        return 2;
    }

    @Override
    public int getExtraCharges(LivingEntity entity, IAoVCapability cap) {
        return IAoVCapability.isImprovedCentered(entity, cap) ? this.getMaxCharges() : super.getExtraCharges(entity, cap);
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public double getMaxDistance() {
        return 0.0;
    }

    @Override
    public int getCoolDown() {
        return 90;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean isCastOnTarget(PlayerEntity caster, IAoVCapability cap, LivingEntity target) {
        return false;
    }

    @Override
    public boolean shouldDisable(@Nullable PlayerEntity caster, IAoVCapability cap) {
        IPolymorphCapability poly = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.POLYMORPH);
        return poly == null || poly.getMorph() != IPolymorphCapability.Morph.Wolf;
    }

    @Override
    public boolean cast(Ability ability, PlayerEntity caster, LivingEntity target) {
        IAoVCapability cap = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.AOV);
        if (cap == null) {
            return false;
        }
        float damage = 4.0f * (1.0f + cap.getSpellPower() * (IAoVCapability.isImprovedCentered((LivingEntity)caster, cap) ? 2.0f : 1.0f) / 100.0f);
        IPolymorphCapability poly = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.POLYMORPH);
        if (poly != null) {
            poly.callWolves(caster.field_70170_p, caster, damage);
        }
        return true;
    }

    @Override
    public ResourceLocation getIcon() {
        return ICON;
    }
}

