/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.druid;

import com.google.common.collect.Sets;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.capabilities.polymorph.IPolymorphCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.helper.RayTraceHelper;

public class FuriousClaw
extends AbilityBase {
    public static final byte BIT = 8;
    private static final int CHARGES = 10;
    public static final float DAMAGE = 2.0f;
    private static final String UNLOC = "aov.spells.furiousclaw";
    private static final ResourceLocation ICON = new ResourceLocation("aov", "textures/spells/furiousclaw.png");

    public FuriousClaw() {
        super(new TranslationTextComponent(UNLOC.concat(".name"), new Object[0]), new TranslationTextComponent("", new Object[0]), new TranslationTextComponent("aov.spells.global.charges", new Object[]{10}), new TranslationTextComponent("aov.spells.global.damage", new Object[]{Float.valueOf(2.0f)}), new TranslationTextComponent("", new Object[0]), new TranslationTextComponent(UNLOC.concat(".desc"), new Object[0]));
    }

    public static boolean invoke(byte bit, PlayerEntity caster, AbilityBase ability) {
        IPolymorphCapability cap = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.POLYMORPH);
        if (cap == null || cap.getMorph() != IPolymorphCapability.Morph.Wolf) {
            return false;
        }
        if (caster.field_70170_p.field_72995_K) {
            caster.func_184609_a(Hand.MAIN_HAND);
        }
        cap.addFlagBits(bit);
        RayTraceResult ray = RayTraceHelper.tracePath((Entity)caster, caster.field_70170_p, caster, (int)caster.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e(), 1.0f, (HashSet<Entity>)Sets.newHashSet((Object[])new Entity[]{caster}));
        if (ray instanceof EntityRayTraceResult) {
            caster.func_71059_n(((EntityRayTraceResult)ray).func_216348_a());
            IAoVCapability aov = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.AOV);
            if (aov != null) {
                aov.addExp((Entity)caster, 20, ability);
            }
        }
        cap.subtractFlagBits(bit);
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)UNLOC.concat(".name"), (Object[])new Object[0]);
    }

    @Override
    public int getMaxCharges() {
        return 10;
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public int getExtraCharges(LivingEntity entity, IAoVCapability cap) {
        return IAoVCapability.isImprovedCentered(entity, cap) ? this.getMaxCharges() : super.getExtraCharges(entity, cap);
    }

    @Override
    public double getMaxDistance() {
        return 0.0;
    }

    @Override
    public int getCoolDown() {
        return 30;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean isCastOnTarget(PlayerEntity caster, IAoVCapability cap, LivingEntity target) {
        return false;
    }

    @Override
    public boolean shouldDisable(@Nullable PlayerEntity caster, IAoVCapability cap) {
        IPolymorphCapability poly = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.POLYMORPH);
        return poly == null || poly.getMorph() != IPolymorphCapability.Morph.Wolf;
    }

    @Override
    public boolean cast(Ability ability, PlayerEntity caster, LivingEntity target) {
        return FuriousClaw.invoke((byte)8, caster, this);
    }

    @Override
    public ResourceLocation getIcon() {
        return ICON;
    }

    @Override
    public boolean runOnClient() {
        return true;
    }
}

