/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.favoredsoul;

import java.util.Objects;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.capabilities.leap.ILeapCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.helper.MotionHelper;
import tamaized.aov.registry.AoVPotions;
import tamaized.aov.registry.SoundEvents;

public class LeapOfFaith
extends AbilityBase {
    public LeapOfFaith() {
        super(new TranslationTextComponent(LeapOfFaith.getStaticName(), new Object[0]), new TranslationTextComponent("", new Object[0]), new TranslationTextComponent("aov.spells.global.charges", new Object[]{"aov.gui.infinite"}), new TranslationTextComponent("", new Object[0]), new TranslationTextComponent("aov.spells.leapoffaith.desc", new Object[0]));
    }

    public static String getStaticName() {
        return "aov.spells.leapoffaith.name";
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocation("aov", "textures/spells/leapoffaith.png");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)LeapOfFaith.getStaticName(), (Object[])new Object[0]);
    }

    @Override
    public int getCoolDown() {
        return 15;
    }

    @Override
    public int getMaxCharges() {
        return -1;
    }

    @Override
    public int getChargeCost() {
        return 0;
    }

    @Override
    public double getMaxDistance() {
        return 1.0;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean isCastOnTarget(PlayerEntity caster, IAoVCapability cap, LivingEntity target) {
        return false;
    }

    @Override
    public boolean cast(Ability ability, PlayerEntity caster, LivingEntity target) {
        Vec3d vec = caster.func_70676_i(1.0f);
        double distance = 3.5;
        MotionHelper.addMotion((Entity)caster, new Vec3d(vec.field_72450_a * distance, 1.0, vec.field_72449_c * distance));
        caster.func_195064_c(new EffectInstance((Effect)Objects.requireNonNull(AoVPotions.slowFall.get()), 300));
        ILeapCapability cap = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.LEAP);
        if (cap != null) {
            cap.setLeapDuration(300);
        }
        SoundEvents.playMovingSoundOnServer(SoundEvents.boost, (Entity)caster);
        return true;
    }
}

