/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.favoredsoul;

import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.entity.ProjectileNimbusRay;

public class NimbusRay
extends AbilityBase {
    private static final int damage = 4;
    private static final int charges = 6;
    private static final int distance = 20;

    public NimbusRay() {
        super(new TranslationTextComponent(NimbusRay.getStaticName(), new Object[0]), new TranslationTextComponent("", new Object[0]), new TranslationTextComponent("aov.spells.global.charges", new Object[]{6}), new TranslationTextComponent("aov.spells.global.range", new Object[]{20}), new TranslationTextComponent("aov.spells.global.damage", new Object[]{4}), new TranslationTextComponent("", new Object[0]), new TranslationTextComponent("aov.spells.nimbus.desc", new Object[0]));
    }

    public static String getStaticName() {
        return "aov.spells.nimbus.name";
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocation("aov", "textures/spells/nimbus.png");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)NimbusRay.getStaticName(), (Object[])new Object[0]);
    }

    @Override
    public int getCoolDown() {
        return 2;
    }

    @Override
    public int getMaxCharges() {
        return 6;
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public double getMaxDistance() {
        return 20.0;
    }

    @Override
    public boolean usesInvoke() {
        return false;
    }

    @Override
    public boolean isCastOnTarget(PlayerEntity caster, IAoVCapability cap, LivingEntity target) {
        return false;
    }

    @Override
    public boolean cast(Ability ability, PlayerEntity caster, LivingEntity target) {
        IAoVCapability cap = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.AOV);
        if (cap == null) {
            return false;
        }
        int a = (int)(4.0f * (1.0f + cap.getSpellPower() / 100.0f));
        ProjectileNimbusRay ray = new ProjectileNimbusRay(caster.field_70170_p, caster, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v);
        ray.setSpell(this);
        ray.setColor(-39169);
        ray.func_70239_b(a);
        ray.setMaxRange(20);
        caster.field_70170_p.func_217376_c((Entity)ray);
        return true;
    }
}

