/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.abilities.paladin;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.client.ParticleHelper;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Ability;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.registry.AoVPotions;
import tamaized.aov.registry.SoundEvents;

public class Aid
extends AbilityBase {
    private static final String name = "aov.spells.aid.name";
    private static final int charges = 5;
    private static final double range = 3.0;

    public Aid() {
        super(new TranslationTextComponent(name, new Object[0]), new TranslationTextComponent("", new Object[0]), new TranslationTextComponent("aov.spells.global.charges", new Object[]{5}), new TranslationTextComponent("aov.spells.global.range", new Object[]{3.0}), new TranslationTextComponent("", new Object[0]), new TranslationTextComponent("aov.spells.aid.desc", new Object[0]));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getName() {
        return I18n.func_135052_a((String)name, (Object[])new Object[0]);
    }

    @Override
    public double getMaxDistance() {
        return 3.0;
    }

    @Override
    public int getMaxCharges() {
        return 5;
    }

    @Override
    public boolean usesInvoke() {
        return true;
    }

    protected int getParticleColor() {
        return -1;
    }

    @Override
    public boolean isCastOnTarget(PlayerEntity caster, IAoVCapability cap, LivingEntity target) {
        return IAoVCapability.canBenefit((Entity)caster, cap, target);
    }

    @Override
    public boolean cast(Ability ability, PlayerEntity caster, LivingEntity e) {
        IAoVCapability cap = CapabilityList.getCap((ICapabilityProvider)caster, CapabilityList.AOV);
        if (cap == null) {
            return false;
        }
        if (cap.getInvokeMass()) {
            this.castAsMass((LivingEntity)caster, cap);
        } else if (e == null) {
            this.addPotionEffects((LivingEntity)caster);
        } else if (IAoVCapability.canBenefit((Entity)caster, cap, e)) {
            this.addPotionEffects(e);
        }
        SoundEvents.playMovingSoundOnServer(SoundEvents.cast_2, (Entity)caster);
        cap.addExp((Entity)caster, 12, this);
        return true;
    }

    private void addPotionEffects(LivingEntity entity) {
        entity.func_195064_c(new EffectInstance(Effects.field_76444_x, 6000));
        entity.func_195064_c(new EffectInstance((Effect)Objects.requireNonNull(AoVPotions.aid.get()), 6000));
    }

    private void castAsMass(LivingEntity caster, IAoVCapability cap) {
        int range = (int)(this.getMaxDistance() * 2.0);
        ParticleHelper.spawnParticleMesh(ParticleHelper.MeshType.BURST, ParticleHelper.ParticleType.Fluff, caster.field_70170_p, caster.func_174791_d(), range, this.getParticleColor());
        List list = caster.field_70170_p.func_217357_a(LivingEntity.class, new AxisAlignedBB(caster.func_180425_c().func_177982_a(-range, -range, -range), caster.func_180425_c().func_177982_a(range, range, range)));
        for (LivingEntity entity : list) {
            if (!IAoVCapability.canBenefit((Entity)caster, cap, entity)) continue;
            this.addPotionEffects(entity);
            cap.addExp((Entity)caster, 12, this);
        }
    }

    @Override
    public int getChargeCost() {
        return 1;
    }

    @Override
    public int getCoolDown() {
        return 12;
    }

    @Override
    public ResourceLocation getIcon() {
        return new ResourceLocation("aov", "textures/spells/aid.png");
    }
}

