/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.core.skills;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import tamaized.aov.common.core.abilities.AbilityBase;
import tamaized.aov.common.core.skills.AoVSkills;

public class AoVSkill {
    private final List<AbilityBase> abilities;
    private final List<TranslationTextComponent> description = Lists.newArrayList();
    private ITextComponent descriptionCache;
    private final TranslationTextComponent name;
    private final ResourceLocation icon;
    private final int level;
    private final int spentpoints;
    private final int charges;
    private final int cost;
    private final int spellpower;
    private final int dodge;
    private final int doublestrike;
    private final boolean core;
    private final AoVSkill parent;

    public AoVSkill(TranslationTextComponent name, ResourceLocation icon, int level, int spentpoints, int charges, int cost, int spellpower, int dodge, int doublestrike, boolean core, AoVSkill parent, List<AbilityBase> spells, TranslationTextComponent ... desc) {
        this.name = name;
        this.icon = icon;
        this.level = level;
        this.spentpoints = spentpoints;
        this.charges = charges;
        this.cost = cost;
        this.spellpower = spellpower;
        this.dodge = dodge;
        this.doublestrike = doublestrike;
        this.core = core;
        this.parent = parent;
        this.abilities = spells;
    }

    public AoVSkill setupTooltip(TranslationTextComponent desc) {
        this.description.clear();
        this.addToDescription(this.name);
        if (this.isClassCore()) {
            this.addToDescription(new TranslationTextComponent("aov.skill.global.core", new Object[0]));
        }
        this.addToDescription(new TranslationTextComponent[0]);
        if (this.getCharges() > 0) {
            this.addToDescription(new TranslationTextComponent("aov.skill.global.charge", new Object[]{this.getCharges()}));
        }
        if (this.spellpower > 0) {
            this.addToDescription(new TranslationTextComponent("aov.skill.global.spellpower", new Object[]{this.spellpower}));
        }
        if (this.dodge > 0) {
            this.addToDescription(new TranslationTextComponent("aov.skill.global.dodge", new Object[]{this.dodge}));
        }
        if (this.doublestrike > 0) {
            this.addToDescription(new TranslationTextComponent("aov.skill.global.doublestrike", new Object[]{this.doublestrike}));
        }
        if (!this.isClassCore()) {
            this.addToDescription(new TranslationTextComponent[0]);
            if (this.level > 0) {
                this.addToDescription(new TranslationTextComponent("aov.skill.global.minlevel", new Object[]{this.level}));
            }
            if (this.spentpoints > 0) {
                this.addToDescription(new TranslationTextComponent("aov.skill.global.minpoint", new Object[]{this.spentpoints}));
            }
            if (this.parent != null) {
                this.addToDescription(new TranslationTextComponent("aov.skill.global.parent", new Object[0]), this.parent.getName());
            }
        }
        if (desc != null) {
            this.addToDescription(new TranslationTextComponent[0]);
            this.addToDescription(desc);
        }
        return this;
    }

    private void addToDescription(TranslationTextComponent ... components) {
        this.description.addAll(Arrays.asList(components));
        this.description.add(new TranslationTextComponent("\n", new Object[0]));
    }

    public final int getID() {
        return AoVSkills.getID(this);
    }

    public TranslationTextComponent getName() {
        return this.name;
    }

    public final List<AbilityBase> getAbilities() {
        return this.abilities;
    }

    public int getCharges() {
        return this.charges;
    }

    public int getSpellPower() {
        return this.spellpower;
    }

    public int getDodge() {
        return this.dodge;
    }

    public int getDoubleStrike() {
        return this.doublestrike;
    }

    public boolean isClassCore() {
        return this.core;
    }

    public AoVSkill getParent() {
        return this.parent;
    }

    public int getCost() {
        return this.cost;
    }

    public int getLevel() {
        return this.level;
    }

    public int getSpentPoints() {
        return this.spentpoints;
    }

    public ResourceLocation getIcon() {
        return this.icon;
    }

    @OnlyIn(value=Dist.CLIENT)
    public final List<String> getDescription() {
        ArrayList list = Lists.newArrayList();
        for (TranslationTextComponent s : this.description) {
            Object[] args = new Object[s.func_150271_j().length];
            for (int index = 0; index < args.length; ++index) {
                args[index] = I18n.func_135052_a((String)String.valueOf(s.func_150271_j()[index]), (Object[])new Object[0]);
            }
            list.add(I18n.func_135052_a((String)s.func_150268_i(), (Object[])args));
        }
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    public final ITextComponent getDescriptionAsTextComponent() {
        if (this.descriptionCache == null && !this.description.isEmpty()) {
            TranslationTextComponent component = new TranslationTextComponent(this.description.get(0).func_150268_i(), this.description.get(0).func_150271_j());
            for (int i = 1; i < this.description.size(); ++i) {
                component.func_150257_a((ITextComponent)new TranslationTextComponent(this.description.get(i).func_150268_i(), this.description.get(i).func_150271_j()));
            }
            this.descriptionCache = component.func_150255_a(new Style().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)component)));
        }
        return this.descriptionCache;
    }
}

