/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.entity;

import java.util.Objects;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.entity.ProjectileBase;
import tamaized.aov.registry.AoVDamageSource;
import tamaized.aov.registry.AoVEntities;
import tamaized.aov.registry.SoundEvents;

public class EntityMalefic
extends ProjectileBase {
    private LivingEntity target;

    public EntityMalefic(World worldIn) {
        super((EntityType)Objects.requireNonNull(AoVEntities.entitymalefic.get()), worldIn);
        this.setDamageRangeSpeed(2.0, 0.0f, 0.0);
    }

    public EntityMalefic(World world, PlayerEntity shooter) {
        super((EntityType)Objects.requireNonNull(AoVEntities.entitymalefic.get()), world, (LivingEntity)shooter);
    }

    public EntityMalefic(World world, PlayerEntity shooter, double x, double y, double z) {
        super((EntityType)Objects.requireNonNull(AoVEntities.entitymalefic.get()), world, (LivingEntity)shooter, x, y, z);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    @Override
    public void func_70071_h_() {
        block4: {
            block2: {
                block3: {
                    if (this.field_70170_p.field_72995_K) break block2;
                    if (this.target != null && !this.target.field_70128_L) break block3;
                    LivingEntity closest = null;
                    double radius = 10.0;
                    IAoVCapability cap = CapabilityList.getCap((ICapabilityProvider)this.field_70250_c, CapabilityList.AOV);
                    for (LivingEntity e : this.field_70170_p.func_217357_a(LivingEntity.class, new AxisAlignedBB(this.field_70165_t - radius, this.field_70163_u - radius, this.field_70161_v - radius, this.field_70165_t + radius, this.field_70163_u + radius, this.field_70161_v + radius))) {
                        if (this.field_70250_c == e || cap != null && cap.hasSelectiveFocus() && !IAoVCapability.selectiveTarget(this.field_70250_c, cap, e) || closest != null && !(this.func_70032_d((Entity)closest) > this.func_70032_d((Entity)e))) continue;
                        closest = e;
                    }
                    this.target = closest;
                    break block4;
                }
                if (this.field_70173_aa % 8 != 0) break block4;
                double d0 = this.target.field_70165_t - this.field_70165_t;
                double d1 = this.target.func_174813_aQ().field_72338_b + (double)(this.target.func_213302_cg() / 2.0f) - this.field_70163_u;
                double d2 = this.target.field_70161_v - this.field_70161_v;
                this.func_70186_c(d0, d1, d2, (float)this.getSpeed(), 14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4);
                break block4;
            }
            for (int i = 0; i < 5; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197624_q, this.field_70165_t + this.field_70170_p.field_73012_v.nextDouble() - 0.5, this.field_70163_u + this.field_70170_p.field_73012_v.nextDouble() - 0.5, this.field_70161_v + this.field_70170_p.field_73012_v.nextDouble() - 0.5, 0.0, (double)5.0E-4f, 0.0);
            }
        }
        super.func_70071_h_();
    }

    @Override
    protected DamageSource getDamageSource() {
        return AoVDamageSource.createEntityDamageSource(AoVDamageSource.COSMIC, this.field_70250_c);
    }

    @Override
    protected float getDamageAmp(double damage, Entity shooter, Entity target) {
        return (float)damage;
    }

    @Override
    protected void func_184548_a(LivingEntity entity) {
        if (this.field_70250_c != null && !this.field_70250_c.field_70128_L) {
            IAoVCapability cap = CapabilityList.getCap((ICapabilityProvider)this.field_70250_c, CapabilityList.AOV);
            if (cap != null) {
                cap.addExp(this.field_70250_c, 12, this.getSpell());
            }
            SoundEvents.playMovingSoundOnServer(SoundEvents.malefic_hit, (Entity)entity);
        }
    }

    @Override
    protected void blockHit(BlockState state, BlockPos pos) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_184133_a(null, pos, SoundEvents.malefic_hit, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        }
    }
}

