/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.entity;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Abilities;
import tamaized.aov.registry.AoVEntities;

public class EntitySpellBladeBarrier
extends Entity
implements IEntityAdditionalSpawnData {
    private Entity caster;
    private int life = 600;
    private int tick = this.life + 1;
    private float damage = 1.0f;
    private int range = 10;
    private List<LivingEntity> entityList = Lists.newArrayList();

    public EntitySpellBladeBarrier(World worldIn) {
        super((EntityType)Objects.requireNonNull(AoVEntities.entityspellbladebarrier.get()), worldIn);
        this.field_70158_ak = true;
    }

    public EntitySpellBladeBarrier(World world, Entity entity, float dmg, int r) {
        this(world);
        this.caster = entity;
        this.damage = dmg;
        this.range = r;
        this.func_70634_a(this.caster.field_70165_t, this.caster.field_70163_u, this.caster.field_70161_v);
        this.tick = 0;
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeInt(this.tick);
        buffer.writeInt(this.range);
    }

    public void readSpawnData(PacketBuffer data) {
        this.tick = data.readInt();
        this.range = data.readInt();
    }

    public int getRange() {
        return this.range;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(@Nonnull CompoundNBT compound) {
    }

    protected void func_213281_b(@Nonnull CompoundNBT compound) {
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.caster == null || !this.caster.func_70089_S() || this.tick >= this.life) {
            this.func_70106_y();
            return;
        }
        List list = this.field_70170_p.func_72839_b(this.caster, new AxisAlignedBB(this.func_180425_c().func_177982_a(-this.range, -2, -this.range), this.func_180425_c().func_177982_a(this.range, 2, this.range)));
        Iterator<LivingEntity> iter = this.entityList.iterator();
        while (iter.hasNext()) {
            LivingEntity e = iter.next();
            if (list.contains(e)) continue;
            this.doDamage(e);
            iter.remove();
        }
        for (Entity e : list) {
            if (!(e instanceof LivingEntity) || this.entityList.contains(e)) continue;
            this.doDamage((LivingEntity)e);
            this.entityList.add((LivingEntity)e);
        }
        ++this.tick;
    }

    private void doDamage(LivingEntity e) {
        IAoVCapability cap = CapabilityList.getCap((ICapabilityProvider)this.caster, CapabilityList.AOV);
        if (cap != null) {
            if (IAoVCapability.selectiveTarget(this.caster, cap, e)) {
                e.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this.caster), this.damage);
                cap.addExp(this.caster, 20, Abilities.bladeBarrier);
            }
        } else {
            e.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this.caster), this.damage);
        }
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

