/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.entity;

import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.AbilityBase;

public abstract class ProjectileBase
extends AbstractArrowEntity
implements IProjectile,
IEntityAdditionalSpawnData {
    public Entity field_70250_c;
    private int ticksInAir;
    private double damage;
    private double speed = 0.5;
    private float range = 0.0f;
    private int maxRange = -1;
    private Vec3d startingPoint = this.func_174791_d();
    private AbilityBase parentSpell;
    private int color = -1;

    public ProjectileBase(EntityType type, World worldIn) {
        super(type, worldIn);
        this.field_70251_a = AbstractArrowEntity.PickupStatus.DISALLOWED;
        this.damage = 2.0;
        this.field_70158_ak = true;
    }

    public ProjectileBase(EntityType type, World worldIn, double x, double y, double z) {
        this(type, worldIn);
        this.func_70107_b(x, y, z);
        this.startingPoint = this.func_174791_d();
    }

    public ProjectileBase(EntityType type, World worldIn, LivingEntity shooter) {
        this(type, worldIn, shooter, shooter.field_70165_t, shooter.field_70163_u, shooter.field_70161_v);
    }

    public ProjectileBase(EntityType type, World worldIn, LivingEntity shooter, double x, double y, double z) {
        this(type, worldIn);
        this.field_70250_c = shooter;
        this.func_70107_b(x, y + (double)shooter.func_70047_e(), z);
        this.startingPoint = this.func_174791_d();
        Vec3d vec = shooter.func_70676_i(1.0f);
        this.setTheVelocity(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public ProjectileBase(EntityType type, World worldIn, LivingEntity shooter, LivingEntity target, float dmg) {
        this(type, worldIn, shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e() - (double)0.1f, shooter.field_70161_v);
        this.field_70250_c = shooter;
        this.damage = dmg;
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 2.0f) - this.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        this.func_70186_c(d0, d1, d2, 1.6f, 14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int c) {
        this.color = c;
    }

    public void setTheVelocity(double x, double y, double z) {
        this.func_213293_j(x, y, z);
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.29577951308232);
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
        }
    }

    public AbilityBase getSpell() {
        return this.parentSpell;
    }

    public void setSpell(AbilityBase ability) {
        this.parentSpell = ability;
    }

    public void setMaxRange(int range) {
        this.maxRange = range;
    }

    public float getRange() {
        return this.range;
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setSpeed(int s) {
        this.speed = s;
    }

    public double func_70242_d() {
        return this.damage;
    }

    public void func_70239_b(double damageIn) {
        this.damage = damageIn;
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeDouble(this.field_70165_t);
        buffer.writeDouble(this.field_70163_u);
        buffer.writeDouble(this.field_70161_v);
        buffer.writeDouble(this.damage);
        buffer.writeFloat(this.range);
        buffer.writeDouble(this.speed);
        buffer.writeInt(this.color);
    }

    public void readSpawnData(PacketBuffer data) {
        this.func_70107_b(data.readDouble(), data.readDouble(), data.readDouble());
        this.setDamageRangeSpeed(data.readDouble(), data.readFloat(), data.readDouble());
        this.setColor(data.readInt());
    }

    protected void func_70088_a() {
    }

    public boolean func_70241_g() {
        return false;
    }

    public void func_70243_d(boolean critical) {
    }

    public void func_70071_h_() {
        Object voxelshape;
        BlockPos blockpos;
        BlockState iblockstate;
        this.func_70030_z();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.func_213322_ci().field_72450_a * this.func_213322_ci().field_72450_a + this.func_213322_ci().field_72449_c * this.func_213322_ci().field_72449_c));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72449_c) * 57.29577951308232);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.func_213322_ci().field_72448_b, f) * 57.29577951308232);
        }
        if (!(iblockstate = this.field_70170_p.func_180495_p(blockpos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v))).isAir((IBlockReader)this.field_70170_p, blockpos) && !(voxelshape = iblockstate.func_196952_d((IBlockReader)this.field_70170_p, blockpos)).func_197766_b()) {
            for (AxisAlignedBB axisalignedbb : voxelshape.func_197756_d()) {
                if (!axisalignedbb.func_186670_a(blockpos).func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) continue;
                this.blockHit(iblockstate, blockpos);
                this.func_70106_y();
                return;
            }
        }
        ++this.ticksInAir;
        if (this.maxRange >= 0) {
            if (this.startingPoint.func_72438_d(this.func_174791_d()) >= (double)this.maxRange) {
                this.func_70106_y();
            }
        } else if (this.ticksInAir > 200) {
            this.func_70106_y();
        }
        if (!this.field_70170_p.field_72995_K) {
            for (Entity e : this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_186662_g(this.speed * 2.0))) {
                if (e == this || e == this.field_70250_c || !this.canHitEntity(e)) continue;
                this.onHit(e);
            }
        }
        this.field_70165_t += this.func_213322_ci().field_72450_a * this.speed;
        this.field_70163_u += this.func_213322_ci().field_72448_b * this.speed;
        this.field_70161_v += this.func_213322_ci().field_72449_c * this.speed;
        float f4 = MathHelper.func_76133_a((double)(this.func_213322_ci().field_72450_a * this.func_213322_ci().field_72450_a + this.func_213322_ci().field_72449_c * this.func_213322_ci().field_72449_c));
        this.field_70177_z = (float)(Math.atan2(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72449_c) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.func_213322_ci().field_72448_b, (double)f4) * 57.29577951308232);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float f1 = 0.99f;
        float f2 = this.range;
        if (this.func_70090_H()) {
            this.func_70106_y();
            for (int l = 0; l < 4; ++l) {
                f4 = 0.25f;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.field_70165_t - this.func_213322_ci().field_72450_a * (double)f4, this.field_70163_u - this.func_213322_ci().field_72448_b * (double)f4, this.field_70161_v - this.func_213322_ci().field_72449_c * (double)f4, this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b, this.func_213322_ci().field_72449_c);
            }
            f1 = 0.6f;
        }
        if (this.func_70026_G()) {
            this.func_70066_B();
        }
        this.func_213293_j(this.func_213322_ci().field_72450_a * (double)f1, this.func_213322_ci().field_72448_b * (double)f1 - (double)f2, this.func_213322_ci().field_72449_c * (double)f1);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_145775_I();
        this.postTick();
    }

    protected void postTick() {
    }

    protected boolean canHitEntity(Entity entity) {
        IAoVCapability cap = CapabilityList.getCap((ICapabilityProvider)this.field_70250_c, CapabilityList.AOV);
        return entity instanceof LivingEntity && (cap == null || IAoVCapability.selectiveTarget(this.field_70250_c, cap, (LivingEntity)entity));
    }

    protected abstract DamageSource getDamageSource();

    protected abstract float getDamageAmp(double var1, Entity var3, Entity var4);

    protected void func_184549_a(RayTraceResult raytraceResultIn) {
    }

    protected void onHit(Entity entity) {
        DamageSource damagesource = this.getDamageSource();
        if (this.func_70027_ad() && !(entity instanceof EndermanEntity)) {
            entity.func_70015_d(5);
        }
        if (entity.func_70097_a(damagesource, this.getDamageAmp(this.damage, this.field_70250_c, entity))) {
            if (entity instanceof LivingEntity) {
                LivingEntity entitylivingbase = (LivingEntity)entity;
                this.func_184548_a(entitylivingbase);
                if (this.field_70250_c != null && entitylivingbase != this.field_70250_c && entitylivingbase instanceof PlayerEntity && this.field_70250_c instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)this.field_70250_c).field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(6, 0.0f));
                }
            }
            if (!(entity instanceof EndermanEntity)) {
                this.func_70106_y();
            }
        } else {
            this.func_213293_j(this.func_213322_ci().field_72450_a * (double)-0.1f, this.func_213322_ci().field_72448_b * (double)-0.1f, this.func_213322_ci().field_72449_c * (double)-0.1f);
            this.field_70177_z += 180.0f;
            this.field_70126_B += 180.0f;
            this.ticksInAir = 0;
            if (!this.field_70170_p.field_72995_K && this.func_213322_ci().field_72450_a * this.func_213322_ci().field_72450_a + this.func_213322_ci().field_72448_b * this.func_213322_ci().field_72448_b + this.func_213322_ci().field_72449_c * this.func_213322_ci().field_72449_c < (double)0.001f) {
                if (this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED) {
                    this.func_70099_a(this.func_184550_j(), 0.1f);
                }
                this.func_70106_y();
            }
        }
    }

    protected abstract void func_184548_a(LivingEntity var1);

    protected abstract void blockHit(BlockState var1, BlockPos var2);

    public void func_213281_b(CompoundNBT nbt) {
        nbt.func_74780_a("damage", this.damage);
        nbt.func_74776_a("range", this.range);
        nbt.func_74780_a("speed", this.speed);
        nbt.func_74768_a("maxRange", this.maxRange);
    }

    public void func_70037_a(CompoundNBT nbt) {
        this.damage = nbt.func_74769_h("damage");
        this.range = nbt.func_74760_g("range");
        this.speed = nbt.func_74769_h("speed");
        this.maxRange = nbt.func_74762_e("maxRange");
    }

    public void func_70100_b_(@Nonnull PlayerEntity p_70100_1_) {
    }

    public void setDamageRangeSpeed(double d, float r, double s) {
        this.damage = d;
        this.range = r;
        this.speed = s;
    }

    @Nonnull
    protected ItemStack func_184550_j() {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

