/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.entity;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.core.abilities.Abilities;
import tamaized.aov.registry.AoVDamageSource;
import tamaized.aov.registry.AoVEntities;

public class ProjectileFlameStrike
extends Entity
implements IProjectile,
IEntityAdditionalSpawnData {
    private Entity attacker;
    private float damage = 2.0f;

    public ProjectileFlameStrike(World worldIn) {
        super((EntityType)Objects.requireNonNull(AoVEntities.projectileflamestrike.get()), worldIn);
        this.func_70015_d(100);
        this.func_213293_j(0.0, -0.8, 0.0);
        this.func_70101_b(0.0f, 90.0f);
    }

    public ProjectileFlameStrike(World world, Entity attacker) {
        this(world);
        this.attacker = attacker;
    }

    public ProjectileFlameStrike(World world, Entity attacker, float dmg) {
        this(world, attacker);
        this.damage = dmg;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    public void setDamage(float d) {
        this.damage = d;
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeDouble(this.field_70165_t);
        buffer.writeDouble(this.field_70163_u);
        buffer.writeDouble(this.field_70161_v);
    }

    public void readSpawnData(PacketBuffer data) {
        this.func_70107_b(data.readDouble(), data.readDouble(), data.readDouble());
    }

    public void func_70071_h_() {
        this.func_70030_z();
        if (this.field_70170_p.field_72995_K) {
            Vec3d vec = this.func_70676_i(1.0f);
            for (int index = 0; index < 20; ++index) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.field_70165_t, this.field_70163_u, this.field_70161_v, -(0.015 * vec.field_72450_a + ((double)this.field_70146_Z.nextFloat() * 0.5 - 0.25)), 0.015 * vec.field_72448_b + ((double)this.field_70146_Z.nextFloat() * 0.5 - 0.25), -(0.015 * vec.field_72449_c + ((double)this.field_70146_Z.nextFloat() * 0.5 - 0.25)));
            }
        }
        Vec3d vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d = vec3d1.func_178787_e(this.func_213322_ci());
        BlockRayTraceResult ray = this.field_70170_p.func_217299_a(new RayTraceContext(vec3d1, vec3d, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
        switch (ray.func_216346_c()) {
            case BLOCK: 
            case ENTITY: {
                this.explode();
                return;
            }
        }
        this.field_70163_u += this.func_213322_ci().field_72448_b;
    }

    private void explode() {
        int i;
        this.func_70106_y();
        for (LivingEntity entity : this.field_70170_p.func_217357_a(LivingEntity.class, new AxisAlignedBB(this.func_180425_c().func_177982_a(-10, -1, -10), this.func_180425_c().func_177982_a(10, 5, 10)))) {
            if (this.attacker != null) {
                IAoVCapability cap = CapabilityList.getCap((ICapabilityProvider)this.attacker, CapabilityList.AOV);
                if (entity == this.attacker || cap != null && !IAoVCapability.selectiveTarget(this.attacker, cap, entity)) continue;
                if (cap != null) {
                    cap.addExp(this.attacker, 20, Abilities.flameStrike);
                }
            }
            entity.func_70015_d(15);
            entity.func_70097_a(AoVDamageSource.createEntityDamageSource(DamageSource.field_76372_a, this.attacker), this.damage);
        }
        for (i = 0; i <= 80; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.field_70165_t, this.field_70163_u, this.field_70161_v, (double)(this.field_70170_p.field_73012_v.nextFloat() * 1.0f - 0.5f), (double)(this.field_70170_p.field_73012_v.nextFloat() * 0.04f + 0.01f), (double)(this.field_70170_p.field_73012_v.nextFloat() * 1.0f - 0.5f));
        }
        for (i = 0; i <= 100; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197594_E, this.field_70165_t, this.field_70163_u, this.field_70161_v, (double)(this.field_70170_p.field_73012_v.nextFloat() * 0.75f - 0.375f), (double)(this.field_70170_p.field_73012_v.nextFloat() * 0.04f + 0.01f), (double)(this.field_70170_p.field_73012_v.nextFloat() * 0.75f - 0.375f));
        }
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.func_213293_j(x *= (double)velocity, y *= (double)velocity, z *= (double)velocity);
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(@Nonnull CompoundNBT compound) {
    }

    protected void func_213281_b(@Nonnull CompoundNBT compound) {
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

