/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.entity;

import java.util.Objects;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import tamaized.aov.client.particle.ParticleColorSpark;
import tamaized.aov.common.capabilities.CapabilityList;
import tamaized.aov.common.capabilities.aov.IAoVCapability;
import tamaized.aov.common.entity.ProjectileBase;
import tamaized.aov.registry.AoVDamageSource;
import tamaized.aov.registry.AoVEntities;

public class ProjectileNimbusRay
extends ProjectileBase {
    public ProjectileNimbusRay(World worldIn) {
        super((EntityType)Objects.requireNonNull(AoVEntities.projectilenimbusray.get()), worldIn);
        this.setDamageRangeSpeed(2.0, 0.0f, 0.0);
    }

    public ProjectileNimbusRay(World world, PlayerEntity shooter, double x, double y, double z) {
        super((EntityType)Objects.requireNonNull(AoVEntities.projectilenimbusray.get()), world, (LivingEntity)shooter, x, y, z);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    @Override
    protected DamageSource getDamageSource() {
        return AoVDamageSource.createEntityDamageSource(AoVDamageSource.NIMBUS, this.field_70250_c);
    }

    @Override
    protected float getDamageAmp(double damage, Entity shooter, Entity target) {
        return (float)(damage * (double)(target instanceof MonsterEntity && ((MonsterEntity)target).func_70662_br() ? 2 : 1));
    }

    @Override
    protected void func_184548_a(LivingEntity entity) {
        IAoVCapability cap;
        if (this.field_70250_c != null && (cap = CapabilityList.getCap((ICapabilityProvider)this.field_70250_c, CapabilityList.AOV)) != null) {
            cap.addExp(this.field_70250_c, 20, this.getSpell());
        }
    }

    @Override
    protected void blockHit(BlockState state, BlockPos pos) {
    }

    @Override
    protected void postTick() {
        if (this.field_70170_p.field_72995_K) {
            Vec3d vec = this.func_70676_i(1.0f);
            if (!Minecraft.func_71410_x().func_147113_T()) {
                for (int i = 0; i < 2; ++i) {
                    Minecraft.func_71410_x().field_71452_i.func_78873_a(ParticleColorSpark.makeSpark(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, -(0.015 * vec.field_72450_a + ((double)this.field_70146_Z.nextFloat() * 0.125 - 0.0625)), 0.015 * vec.field_72448_b + ((double)this.field_70146_Z.nextFloat() * 0.125 - 0.0625), -(0.015 * vec.field_72449_c + ((double)this.field_70146_Z.nextFloat() * 0.125 - 0.0625)), Minecraft.func_71410_x().field_71452_i, this.getColor() >> 8));
                }
            }
        }
    }
}

