/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.common.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class RayTraceHelper {
    private RayTraceHelper() {
    }

    public static Vec3d[] getPlayerTraceVec(PlayerEntity player, int distance) {
        Vec3d vec3d = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        Vec3d vec3d1 = player.func_70676_i(1.0f);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * (double)distance, vec3d1.field_72448_b * (double)distance, vec3d1.field_72449_c * (double)distance);
        return new Vec3d[]{vec3d, vec3d2};
    }

    public static RayTraceResult tracePath(Entity context, World world, PlayerEntity player, int distance, float size, HashSet<Entity> excluded) {
        Vec3d[] vecs = RayTraceHelper.getPlayerTraceVec(player, distance);
        return RayTraceHelper.tracePath(context, world, vecs[0], vecs[1], size, excluded);
    }

    public static RayTraceResult tracePath(Entity context, World world, Vec3d vec1, Vec3d vec2, float size, HashSet<Entity> excluded) {
        return RayTraceHelper.tracePath(context, world, (float)vec1.field_72450_a, (float)vec1.field_72448_b, (float)vec1.field_72449_c, (float)vec2.field_72450_a, (float)vec2.field_72448_b, (float)vec2.field_72449_c, size, excluded);
    }

    private static RayTraceResult tracePath(Entity context, World world, float x, float y, float z, float tx, float ty, float tz, float size, HashSet<Entity> excluded) {
        Vec3d startVec = new Vec3d((double)x, (double)y, (double)z);
        Vec3d endVec = new Vec3d((double)tx, (double)ty, (double)tz);
        float minX = x < tx ? x : tx;
        float minY = y < ty ? y : ty;
        float minZ = z < tz ? z : tz;
        float maxX = x > tx ? x : tx;
        float maxY = y > ty ? y : ty;
        float maxZ = z > tz ? z : tz;
        AxisAlignedBB bb = new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ).func_72314_b((double)size, (double)size, (double)size);
        ArrayList allEntities = excluded == null ? Lists.newArrayList() : world.func_72839_b(null, bb);
        BlockRayTraceResult blockHit = world.func_217299_a(new RayTraceContext(startVec, endVec, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, context));
        startVec = new Vec3d((double)x, (double)y, (double)z);
        endVec = new Vec3d((double)tx, (double)ty, (double)tz);
        Entity closestHitEntity = null;
        double currentHit = 0.0;
        for (Entity ent : allEntities) {
            Vec3d vec3d1;
            double d1;
            Vec3d vecIntercept;
            if (!ent.func_70067_L() || excluded.contains(ent)) continue;
            float entBorder = ent.func_70111_Y();
            AxisAlignedBB entityBb = ent.func_174813_aQ();
            entityBb = entityBb.func_72314_b((double)entBorder, (double)entBorder, (double)entBorder);
            Optional intercept = entityBb.func_216365_b(startVec, endVec);
            if (entityBb.func_72318_a(startVec)) {
                if (!(currentHit >= 0.0)) continue;
                closestHitEntity = ent;
                vecIntercept = intercept.orElse(startVec);
                currentHit = 0.0;
                continue;
            }
            if (!intercept.isPresent() || !((d1 = startVec.func_72436_e(vec3d1 = (Vec3d)intercept.get())) < currentHit) && currentHit != 0.0) continue;
            if (ent.func_184208_bv() == context.func_184208_bv()) {
                if (currentHit != 0.0) continue;
                closestHitEntity = ent;
                vecIntercept = vec3d1;
                continue;
            }
            closestHitEntity = ent;
            vecIntercept = vec3d1;
            currentHit = d1;
        }
        if (closestHitEntity != null && (blockHit.func_216346_c() == RayTraceResult.Type.MISS || closestHitEntity.func_70092_e((double)x, (double)y, (double)z) <= startVec.func_72436_e(blockHit.func_216347_e()))) {
            blockHit = new EntityRayTraceResult(closestHitEntity);
        }
        return blockHit;
    }
}

