/*
 * Decompiled with CFR 0.152.
 */
package tamaized.aov.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.fml.unsafe.UnsafeHacks;
import tamaized.aov.network.client.ClientPacketHandlerAoVData;
import tamaized.aov.network.client.ClientPacketHandlerAoVSimpleData;
import tamaized.aov.network.client.ClientPacketHandlerAstroAnimation;
import tamaized.aov.network.client.ClientPacketHandlerAstroData;
import tamaized.aov.network.client.ClientPacketHandlerFloatyText;
import tamaized.aov.network.client.ClientPacketHandlerLeap;
import tamaized.aov.network.client.ClientPacketHandlerMovingSound;
import tamaized.aov.network.client.ClientPacketHandlerOpenGui;
import tamaized.aov.network.client.ClientPacketHandlerParticle;
import tamaized.aov.network.client.ClientPacketHandlerParticleMesh;
import tamaized.aov.network.client.ClientPacketHandlerPlayerMotion;
import tamaized.aov.network.client.ClientPacketHandlerPolymorphDogAttack;
import tamaized.aov.network.client.ClientPacketHandlerSpawnNonLivingEntity;
import tamaized.aov.network.client.ClientPacketHandlerStunned;
import tamaized.aov.network.server.ServerPacketHandlerPolymorphDogAttack;
import tamaized.aov.network.server.ServerPacketHandlerSpellSkill;

public class NetworkMessages {
    private static int index = 0;

    public static void register(SimpleChannel network) {
        NetworkMessages.registerMessage(network, ServerPacketHandlerSpellSkill.class, IMessage.Side.SERVER);
        NetworkMessages.registerMessage(network, ServerPacketHandlerPolymorphDogAttack.class, IMessage.Side.SERVER);
        NetworkMessages.registerMessage(network, ClientPacketHandlerAoVData.class, IMessage.Side.CLIENT);
        NetworkMessages.registerMessage(network, ClientPacketHandlerAstroData.class, IMessage.Side.CLIENT);
        NetworkMessages.registerMessage(network, ClientPacketHandlerAstroAnimation.class, IMessage.Side.CLIENT);
        NetworkMessages.registerMessage(network, ClientPacketHandlerMovingSound.class, IMessage.Side.CLIENT);
        NetworkMessages.registerMessage(network, ClientPacketHandlerStunned.class, IMessage.Side.CLIENT);
        NetworkMessages.registerMessage(network, ClientPacketHandlerParticleMesh.class, IMessage.Side.CLIENT);
        NetworkMessages.registerMessage(network, ClientPacketHandlerLeap.class, IMessage.Side.CLIENT);
        NetworkMessages.registerMessage(network, ClientPacketHandlerPolymorphDogAttack.class, IMessage.Side.CLIENT);
        NetworkMessages.registerMessage(network, ClientPacketHandlerParticle.class, IMessage.Side.CLIENT);
        NetworkMessages.registerMessage(network, ClientPacketHandlerAoVSimpleData.class, IMessage.Side.CLIENT);
        NetworkMessages.registerMessage(network, ClientPacketHandlerFloatyText.class, IMessage.Side.CLIENT);
        NetworkMessages.registerMessage(network, ClientPacketHandlerPlayerMotion.class, IMessage.Side.CLIENT);
        NetworkMessages.registerMessage(network, ClientPacketHandlerOpenGui.class, IMessage.Side.CLIENT);
        NetworkMessages.registerMessage(network, ClientPacketHandlerSpawnNonLivingEntity.class, IMessage.Side.CLIENT);
    }

    private static <M extends IMessage<M>> void registerMessage(SimpleChannel network, Class<M> type, IMessage.Side side) {
        network.registerMessage(index++, type, IMessage::encode, p -> IMessage.decode(p, type), (m, s) -> IMessage.onMessage(m, s, side));
    }

    public static interface IMessage<SELF extends IMessage<SELF>> {
        public static <M extends IMessage<M>> void encode(M message, PacketBuffer packet) {
            message.toBytes(packet);
        }

        public static <M extends IMessage<M>> M decode(PacketBuffer packet, Class<M> type) {
            return (M)((IMessage)UnsafeHacks.newInstance(type)).fromBytes(packet);
        }

        public static void onMessage(IMessage message, Supplier<NetworkEvent.Context> context, Side side) {
            context.get().enqueueWork(() -> message.handle((PlayerEntity)(side == Side.SERVER ? ((NetworkEvent.Context)context.get()).getSender() : IMessage.getClientSidePlayer().get())));
            context.get().setPacketHandled(true);
        }

        public static Supplier<PlayerEntity> getClientSidePlayer() {
            return new Supplier<PlayerEntity>(){

                @Override
                public PlayerEntity get() {
                    return Minecraft.func_71410_x().field_71439_g;
                }
            };
        }

        public void handle(PlayerEntity var1);

        public void toBytes(PacketBuffer var1);

        public SELF fromBytes(PacketBuffer var1);

        public static enum Side {
            CLIENT,
            SERVER;

        }
    }
}

